/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.IOpenBlocksProxy;
import openblocks.OpenBlocks;
import openblocks.client.ClientTickHandler;
import openblocks.client.GliderPlayerRenderHandler;
import openblocks.client.GlyphPlacementGridRenderer;
import openblocks.client.SleepingBagRenderHandler;
import openblocks.client.SoundEventsManager;
import openblocks.client.bindings.KeyInputHandler;
import openblocks.client.fx.FXLiquidSpray;
import openblocks.client.model.ModelCraneBackpack;
import openblocks.client.renderer.SkyBlockRenderer;
import openblocks.client.renderer.TextureUploader;
import openblocks.client.renderer.block.PathModel;
import openblocks.client.renderer.block.canvas.CanvasTextureManager;
import openblocks.client.renderer.block.canvas.ModelCanvas;
import openblocks.client.renderer.entity.EntityCartographerRenderer;
import openblocks.client.renderer.entity.EntityGlyphRenderer;
import openblocks.client.renderer.entity.EntityHangGliderRenderer;
import openblocks.client.renderer.entity.EntityLuggageRenderer;
import openblocks.client.renderer.entity.EntityMagnetRenderer;
import openblocks.client.renderer.entity.EntityMiniMeRenderer;
import openblocks.client.renderer.entity.EntitySelectionHandler;
import openblocks.client.renderer.item.ModelGlyph;
import openblocks.client.renderer.item.devnull.DevNullModel;
import openblocks.client.renderer.item.stencil.ModelStencil;
import openblocks.client.renderer.item.stencil.StencilItemOverride;
import openblocks.client.renderer.item.stencil.StencilTextureManager;
import openblocks.client.renderer.tileentity.TileEntityAutoEnchantmentTableRenderer;
import openblocks.client.renderer.tileentity.TileEntityBearTrapRenderer;
import openblocks.client.renderer.tileentity.TileEntityCannonRenderer;
import openblocks.client.renderer.tileentity.TileEntityFanRenderer;
import openblocks.client.renderer.tileentity.TileEntityGoldenEggRenderer;
import openblocks.client.renderer.tileentity.TileEntityGraveRenderer;
import openblocks.client.renderer.tileentity.TileEntityImaginaryRenderer;
import openblocks.client.renderer.tileentity.TileEntityPaintMixerRenderer;
import openblocks.client.renderer.tileentity.TileEntityProjectorRenderer;
import openblocks.client.renderer.tileentity.TileEntitySkyRenderer;
import openblocks.client.renderer.tileentity.TileEntitySprinklerRenderer;
import openblocks.client.renderer.tileentity.TileEntityTankRenderer;
import openblocks.client.renderer.tileentity.TileEntityTrophyRenderer;
import openblocks.client.renderer.tileentity.TileEntityVillageHighlighterRenderer;
import openblocks.client.renderer.tileentity.guide.TileEntityBuilderGuideRenderer;
import openblocks.client.renderer.tileentity.guide.TileEntityGuideRenderer;
import openblocks.common.StencilPattern;
import openblocks.common.TrophyHandler;
import openblocks.common.entity.EntityCartographer;
import openblocks.common.entity.EntityGlyph;
import openblocks.common.entity.EntityGoldenEye;
import openblocks.common.entity.EntityHangGlider;
import openblocks.common.entity.EntityLuggage;
import openblocks.common.entity.EntityMagnet;
import openblocks.common.entity.EntityMiniMe;
import openblocks.common.tileentity.TileEntityAutoEnchantmentTable;
import openblocks.common.tileentity.TileEntityBearTrap;
import openblocks.common.tileentity.TileEntityBuilderGuide;
import openblocks.common.tileentity.TileEntityCannon;
import openblocks.common.tileentity.TileEntityFan;
import openblocks.common.tileentity.TileEntityGoldenEgg;
import openblocks.common.tileentity.TileEntityGrave;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.common.tileentity.TileEntityImaginary;
import openblocks.common.tileentity.TileEntityPaintMixer;
import openblocks.common.tileentity.TileEntityProjector;
import openblocks.common.tileentity.TileEntitySky;
import openblocks.common.tileentity.TileEntitySprinkler;
import openblocks.common.tileentity.TileEntityTank;
import openblocks.common.tileentity.TileEntityTrophy;
import openblocks.common.tileentity.TileEntityVillageHighlighter;
import openblocks.enchantments.flimflams.LoreFlimFlam;
import openmods.block.OpenBlock;
import openmods.entity.EntityBlock;
import openmods.entity.renderer.EntityBlockRenderer;
import openmods.model.MappedModelLoader;
import openmods.model.ModelUtils;
import openmods.utils.render.MarkerClassGenerator;

public class ClientProxy
implements IOpenBlocksProxy {
    public void preInit() {
        OBJLoader.INSTANCE.addDomain("openblocks");
        MinecraftForge.EVENT_BUS.register((Object)new FluidTextureRegisterListener(OpenBlocks.Fluids.xpJuice));
        new KeyInputHandler().setup();
        if (Config.flimFlamEnchantmentEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new LoreFlimFlam.DisplayHandler());
        }
        if (OpenBlocks.Blocks.trophy != null) {
            Item trophyItem = Item.func_150898_a((Block)OpenBlocks.Blocks.trophy);
            for (TrophyHandler.Trophy trophy : TrophyHandler.Trophy.VALUES) {
                ClientProxy.registerTrophyItemRenderer(trophyItem, trophy);
            }
        }
        ClientProxy.registerTesrStateMappers();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)MappedModelLoader.builder().put("magic-devnull", (IModel)DevNullModel.INSTANCE).put("magic-path", (IModel)PathModel.INSTANCE).put("magic-stencil", (IModel)ModelStencil.INSTANCE).put("magic-canvas", ModelCanvas.INSTANCE).put("magic-glyph", ModelGlyph.INSTANCE).build("openblocks"));
        RenderingRegistry.registerEntityRenderingHandler(EntityHangGlider.class, EntityHangGliderRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityLuggage.class, EntityLuggageRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMagnet.class, EntityMagnetRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBlock.class, EntityBlockRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMiniMe.class, EntityMiniMeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityGlyph.class, manager -> {
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            return new EntityGlyphRenderer(manager, renderItem);
        });
        EntityCartographerRenderer.registerListener();
        RenderingRegistry.registerEntityRenderingHandler(EntityCartographer.class, EntityCartographerRenderer::new);
        if (OpenBlocks.Items.goldenEye != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityGoldenEye.class, manager -> {
                RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
                return new RenderSnowball(manager, OpenBlocks.Items.goldenEye, renderItem);
            });
        }
        if (OpenBlocks.Items.stencil != null) {
            StencilTextureManager.INSTANCE.register(StencilItemOverride.BACKGROUND_TEXTURE, StencilPattern.values().length);
            MinecraftForge.EVENT_BUS.register((Object)StencilTextureManager.INSTANCE);
            ModelUtils.registerMetaInsensitiveModel((Item)OpenBlocks.Items.stencil);
        }
        if (OpenBlocks.Blocks.canvas != null) {
            MinecraftForge.EVENT_BUS.register((Object)CanvasTextureManager.INSTANCE);
        }
        if (OpenBlocks.Items.stencil != null || OpenBlocks.Blocks.canvas != null) {
            MinecraftForge.EVENT_BUS.register((Object)TextureUploader.INSTANCE);
        }
        if (OpenBlocks.Blocks.elevator != null) {
            ModelUtils.registerMetaInsensitiveModel((Item)Item.func_150898_a((Block)OpenBlocks.Blocks.elevator));
        }
        if (OpenBlocks.Blocks.elevatorRotating != null) {
            ModelUtils.registerMetaInsensitiveModel((Item)Item.func_150898_a((Block)OpenBlocks.Blocks.elevatorRotating));
        }
        if (OpenBlocks.Blocks.sky != null) {
            ModelUtils.registerMetaInsensitiveModel((Block)OpenBlocks.Blocks.sky);
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)SkyBlockRenderer.INSTANCE);
        }
        if (OpenBlocks.Items.heightMap != null) {
            ModelUtils.registerMetaInsensitiveModel((Item)OpenBlocks.Items.heightMap);
        }
        if (OpenBlocks.Blocks.flag != null) {
            ModelUtils.registerMetaInsensitiveModel((Block)OpenBlocks.Blocks.flag);
        }
        if (OpenBlocks.Items.glyph != null) {
            ModelUtils.registerMetaInsensitiveModel((Item)OpenBlocks.Items.glyph);
            MinecraftForge.EVENT_BUS.register((Object)new GlyphPlacementGridRenderer());
        }
        SoundEventsManager.instance.init();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGuide.class, new TileEntityGuideRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBuilderGuide.class, (TileEntitySpecialRenderer)new TileEntityBuilderGuideRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGrave.class, (TileEntitySpecialRenderer)new TileEntityGraveRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTank.class, (TileEntitySpecialRenderer)new TileEntityTankRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTrophy.class, (TileEntitySpecialRenderer)new TileEntityTrophyRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBearTrap.class, (TileEntitySpecialRenderer)new TileEntityBearTrapRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySprinkler.class, (TileEntitySpecialRenderer)new TileEntitySprinklerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCannon.class, (TileEntitySpecialRenderer)new TileEntityCannonRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityImaginary.class, (TileEntitySpecialRenderer)new TileEntityImaginaryRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFan.class, (TileEntitySpecialRenderer)new TileEntityFanRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityVillageHighlighter.class, (TileEntitySpecialRenderer)new TileEntityVillageHighlighterRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAutoEnchantmentTable.class, (TileEntitySpecialRenderer)new TileEntityAutoEnchantmentTableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPaintMixer.class, (TileEntitySpecialRenderer)new TileEntityPaintMixerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySky.class, (TileEntitySpecialRenderer)new TileEntitySkyRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGoldenEgg.class, (TileEntitySpecialRenderer)new TileEntityGoldenEggRenderer());
        if (OpenBlocks.Blocks.projector != null) {
            ModelResourceLocation spinnerModel = new ModelResourceLocation(OpenBlocks.Blocks.projector.getRegistryName(), "spinner");
            TileEntityProjectorRenderer renderer = new TileEntityProjectorRenderer(spinnerModel);
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityProjector.class, (TileEntitySpecialRenderer)renderer);
            MinecraftForge.EVENT_BUS.register((Object)renderer);
        }
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EntityMiniMe.OwnerChangeHandler());
    }

    public void postInit() {
    }

    public void registerRenderInformation() {
        ClientProxy.registerTesrItemRenderers();
        if (OpenBlocks.Items.hangGlider != null) {
            MinecraftForge.EVENT_BUS.register((Object)new GliderPlayerRenderHandler());
        }
        if (OpenBlocks.Items.sonicGlasses != null) {
            MinecraftForge.EVENT_BUS.register((Object)SoundEventsManager.instance);
        }
        if (OpenBlocks.Items.craneBackpack != null) {
            ModelCraneBackpack.instance.init();
        }
        if (OpenBlocks.Items.sleepingBag != null) {
            MinecraftForge.EVENT_BUS.register((Object)new SleepingBagRenderHandler());
        }
        MinecraftForge.EVENT_BUS.register((Object)new EntitySelectionHandler());
        if (OpenBlocks.Items.cartographer != null) {
            EntitySelectionHandler.registerRenderer(EntityCartographer.class, new EntityCartographerRenderer.Selection());
        }
        if (OpenBlocks.Blocks.imaginary != null) {
            MinecraftForge.EVENT_BUS.register((Object)new TileEntityImaginaryRenderer.CacheFlushListener());
        }
    }

    private static void registerTrophyItemRenderer(Item item, TrophyHandler.Trophy trophy) {
        Class markerCls = MarkerClassGenerator.instance.createMarkerCls(TileEntityTrophy.class);
        int meta = trophy.ordinal();
        ForgeHooksClient.registerTESRItemStack((Item)item, (int)meta, (Class)markerCls);
        ClientRegistry.bindTileEntitySpecialRenderer((Class)markerCls, (TileEntitySpecialRenderer)new TileEntityTrophyRenderer(trophy));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(OpenBlocks.location("trophy"), "inventory"));
    }

    private static void visitTesrBlocks(BlockConsumer consumer) {
        consumer.nom(OpenBlocks.Blocks.cannon);
    }

    private static void registerTesrItemRenderers() {
        ClientProxy.visitTesrBlocks(new BlockConsumer(){

            @Override
            public void nomNom(OpenBlock block) {
                Item item = Item.func_150898_a((Block)block);
                ForgeHooksClient.registerTESRItemStack((Item)item, (int)0, (Class)block.getTileClass());
            }
        });
    }

    private static void registerTesrStateMappers() {
        ClientProxy.visitTesrBlocks(new BlockConsumer(){

            @Override
            public void nomNom(OpenBlock block) {
                ImmutableMap.Builder statesBuilder = ImmutableMap.builder();
                ModelResourceLocation location = new ModelResourceLocation(block.getRegistryName(), "dummy");
                for (IBlockState state : block.func_176194_O().func_177619_a()) {
                    statesBuilder.put((Object)state, (Object)location);
                }
                ImmutableMap states = statesBuilder.build();
                ModelLoader.setCustomStateMapper((Block)block, arg_0 -> 2.lambda$nomNom$0((Map)states, arg_0));
            }

            private static /* synthetic */ Map lambda$nomNom$0(Map states, Block blockIn) {
                return states;
            }
        });
    }

    @Override
    public int getParticleSettings() {
        return Minecraft.func_71410_x().field_71474_y.field_74362_aa;
    }

    private static void spawnParticle(Particle spray) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(spray);
    }

    @Override
    public void spawnLiquidSpray(World worldObj, FluidStack fluid, double x, double y, double z, float scale, float gravity, Vec3d velocity) {
        ClientProxy.spawnParticle(new FXLiquidSpray(worldObj, fluid, x, y, z, scale, gravity, velocity));
    }

    private static abstract class BlockConsumer {
        private BlockConsumer() {
        }

        public final void nom(OpenBlock block) {
            if (block != null) {
                this.nomNom(block);
            }
        }

        protected abstract void nomNom(OpenBlock var1);
    }

    private static class FluidTextureRegisterListener {
        private final Fluid[] fluidsToRegister;

        public FluidTextureRegisterListener(Fluid ... fluidsToRegister) {
            this.fluidsToRegister = fluidsToRegister;
        }

        @SubscribeEvent
        public void onTextureStitch(TextureStitchEvent.Pre evt) {
            for (Fluid fluid : this.fluidsToRegister) {
                ResourceLocation fluidTexture = fluid.getStill();
                if (fluidTexture == null) continue;
                evt.getMap().func_174942_a(fluidTexture);
            }
        }
    }
}

