/*
 * Decompiled with CFR 0.152.
 */
package weatherpony.fenceoverhual.api;

import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraftforge.fml.common.Loader;

public class FenceOverhaulAPI {
    public static boolean isLoaded() {
        return Loader.isModLoaded((String)"fenceoverhaul");
    }

    public static Block registerFence(Material material, MapColor mapColor, String type, float hardness, float resistance, SoundType sound, Object fenceMadeFromPlanks_ForCrafting, Object fenceMadeFromSticks_ForCrafting) {
        try {
            Class<?> mod = FenceOverhaulAPI.class.getClassLoader().loadClass("weatherpony.fenceoverhaul.FenceOverhaulMod");
            Method method = mod.getMethod("registerFence", FenceData.class);
            FenceData data = new FenceData(material, mapColor, type, hardness, resistance, sound, fenceMadeFromPlanks_ForCrafting, fenceMadeFromSticks_ForCrafting);
            return (Block)method.invoke(null, data);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class FenceData {
        public final Material material;
        public final MapColor mapColor;
        public final String type;
        public final float hardness;
        public final float resistance;
        public final SoundType sound;
        public final Object fenceMadeFromPlanks_ForCrafting;
        public final Object fenceMadeFromSticks_ForCrafting;

        public FenceData(Material material, MapColor mapColor, String type, float hardness, float resistance, SoundType sound, Object fenceMadeFromPlanks_ForCrafting, Object fenceMadeFromSticks_ForCrafting) {
            this.material = material;
            this.mapColor = mapColor;
            this.type = type;
            this.hardness = hardness;
            this.resistance = resistance;
            this.sound = sound;
            this.fenceMadeFromPlanks_ForCrafting = fenceMadeFromPlanks_ForCrafting;
            this.fenceMadeFromSticks_ForCrafting = fenceMadeFromSticks_ForCrafting;
        }
    }
}

