/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.predefined.StructureAlternateStart;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class StructureBasic
extends Structure {
    private final ArrayList<Tuple<BlockPos, BlockPos>> bedPositions = new ArrayList();
    private final ArrayList<BlockPos> mobSpawnerPos = new ArrayList();
    BlockPos customBlockPos = null;
    private BlockPos signPosition = null;

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        BasicStructureConfiguration.EnumBasicStructureName enumName = config.basicStructureName;
        if (foundBlock instanceof BlockHopper && enumName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedCoop.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof BlockTrapDoor && enumName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else {
            if (foundBlock instanceof BlockBed && config.chosenOption.getHasBedColor()) {
                BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                this.bedPositions.add(new Tuple<BlockPos, BlockPos>(bedHeadPosition, bedFootPosition));
                return true;
            }
            if (foundBlock instanceof BlockMobSpawner && enumName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MonsterMasher.getName()) && Prefab.proxy.getServerConfiguration().includeSpawnersInMasher) {
                this.mobSpawnerPos.add(block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing));
            } else if (foundBlock instanceof BlockSign && enumName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MonsterMasher.getName())) {
                this.signPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            }
        }
        ResourceLocation blockIdentifier = foundBlock.getRegistryName();
        ResourceLocation glassIdentifier = Blocks.field_150399_cn.getRegistryName();
        ResourceLocation glassPaneIdentifier = Blocks.field_150397_co.getRegistryName();
        if (blockIdentifier.func_110624_b().equals(glassIdentifier.func_110624_b()) && blockIdentifier.func_110623_a().endsWith("glass") && config.chosenOption.getHasGlassColor()) {
            blockState = this.getStainedGlassBlock(config.glassColor);
            block.setBlockState(blockState);
            this.priorityOneBlocks.add(block);
            return true;
        }
        if (blockIdentifier.func_110624_b().equals(glassPaneIdentifier.func_110624_b()) && blockIdentifier.func_110623_a().endsWith("glass_pane") && config.chosenOption.getHasGlassColor()) {
            blockState = this.getStainedGlassPaneBlock(config.glassColor);
            BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, this);
            this.priorityOneBlocks.add(block);
            return true;
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        BasicStructureConfiguration.EnumBasicStructureName enumName = config.basicStructureName;
        if (this.customBlockPos != null) {
            if (enumName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedCoop.getName())) {
                for (int i = 0; i < 4; ++i) {
                    EntityChicken entity = new EntityChicken(world);
                    entity.func_70107_b((double)this.customBlockPos.func_177958_n(), (double)this.customBlockPos.func_177984_a().func_177956_o(), (double)this.customBlockPos.func_177952_p());
                    world.func_72838_d((Entity)entity);
                }
            } else if (enumName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.ChickenCoop.getName())) {
                EntityChicken entity = new EntityChicken(world);
                entity.func_70107_b((double)this.customBlockPos.func_177958_n(), (double)this.customBlockPos.func_177977_b().func_177956_o(), (double)this.customBlockPos.func_177952_p());
                world.func_72838_d((Entity)entity);
            } else if (enumName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
                StructureAlternateStart.PlaceMineShaft(world, this.customBlockPos.func_177977_b(), configuration.houseFacing, true);
            }
            this.customBlockPos = null;
        }
        if (enumName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MonsterMasher.getName())) {
            TileEntity tileEntity;
            int monstersPlaced = 0;
            for (BlockPos pos : this.mobSpawnerPos) {
                TileEntity tileEntity2 = world.func_175625_s(pos);
                if (!(tileEntity2 instanceof TileEntityMobSpawner)) continue;
                TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileEntity2;
                switch (monstersPlaced) {
                    case 0: {
                        spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntityZombie.class));
                        break;
                    }
                    case 1: {
                        spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntitySkeleton.class));
                        break;
                    }
                    case 2: {
                        spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntitySpider.class));
                        break;
                    }
                    default: {
                        spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntityCreeper.class));
                    }
                }
                ++monstersPlaced;
            }
            if (this.signPosition != null && (tileEntity = world.func_175625_s(this.signPosition)) instanceof TileEntitySign) {
                TileEntitySign signTile = (TileEntitySign)tileEntity;
                signTile.field_145915_a[0] = new TextComponentString("Lamp On=Mobs");
                signTile.field_145915_a[2] = new TextComponentString("Lamp Off=No Mobs");
            }
        }
        if (this.bedPositions.size() > 0) {
            for (Tuple<BlockPos, BlockPos> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed(world, bedPosition.getFirst(), bedPosition.getSecond(), config.bedColor);
            }
        }
        if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName())) {
            BlockPos airPos = originalPos.func_177981_b(4).func_177967_a(configuration.houseFacing.func_176734_d(), 1);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177972_a(configuration.houseFacing.func_176734_d()).func_177984_a();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177984_a();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177984_a();
            world.func_175698_g(airPos);
        }
    }
}

