/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.structures.base.EnumStructureMaterial;
import com.wuest.prefab.structures.config.InstantBridgeConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureInstantBridge;
import java.io.IOException;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiInstantBridge
extends GuiStructure {
    private static final ResourceLocation structureTopDown = new ResourceLocation("prefab", "textures/gui/instant_bridge_top_down.png");
    protected InstantBridgeConfiguration configuration;
    protected GuiButtonExt btnMaterialType;
    protected GuiSlider sldrBridgeLength;
    protected GuiCheckBox chckIncludeRoof;
    protected GuiSlider sldrInteriorHeight;

    public GuiInstantBridge() {
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.InstantBridge;
    }

    @Override
    protected void Initialize() {
        this.modifiedInitialXAxis = 212;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("InstantBridge", InstantBridgeConfiguration.class);
        this.configuration.pos = this.pos;
        this.structureImageLocation = structureTopDown;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnMaterialType = this.createAndAddButton(4, grayBoxX + 15, grayBoxY + 45, 90, 20, this.configuration.bridgeMaterial.getName());
        this.sldrBridgeLength = this.createAndAddSlider(5, grayBoxX + 15, grayBoxY + 85, 90, 20, "", "", 25.0, 75.0, this.configuration.bridgeLength, false, true);
        this.chckIncludeRoof = this.createAndAddCheckBox(6, grayBoxX + 15, grayBoxY + 112, "prefab.gui.bridge_include_roof", this.configuration.includeRoof);
        this.sldrInteriorHeight = this.createAndAddSlider(7, grayBoxX + 15, grayBoxY + 140, 90, 20, "", "", 3.0, 8.0, this.configuration.interiorHeight, false, true);
        this.sldrInteriorHeight.field_146124_l = this.chckIncludeRoof.isChecked();
        this.btnVisualize = this.createAndAddCustomButton(3, grayBoxX + 25, grayBoxY + 175, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(1, grayBoxX + 310, grayBoxY + 175, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(2, grayBoxX + 150, grayBoxY + 175, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 132;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.func_146276_q_();
        this.drawControlLeftPanel(x + 10, y + 10, 125, 190);
        this.drawControlRightPanel(imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindTexture(this.structureImageLocation);
        Gui.func_152125_a((int)imageLocation, (int)(y + 15), (float)0.0f, (float)0.0f, (int)this.shownImageWidth, (int)this.shownImageHeight, (int)this.shownImageWidth, (int)this.shownImageHeight, (float)this.shownImageWidth, (float)this.shownImageHeight);
    }

    @Override
    protected void postButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawString(GuiLangKeys.translateString("item.prefab:item_instant_bridge.name"), x + 15, y + 17, this.textColor);
        this.drawString(GuiLangKeys.translateString("prefab.gui.bridge_material"), x + 15, y + 35, this.textColor);
        this.drawString(GuiLangKeys.translateString("prefab.gui.bridge_length"), x + 15, y + 75, this.textColor);
        if (this.chckIncludeRoof.isChecked()) {
            this.drawString(GuiLangKeys.translateString("prefab.gui.bridge_interior_height"), x + 15, y + 130, this.textColor);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        int sliderValue = this.sldrBridgeLength.getValueInt();
        if (sliderValue > 75) {
            sliderValue = 75;
        } else if (sliderValue < 25) {
            sliderValue = 25;
        }
        this.configuration.bridgeLength = sliderValue;
        sliderValue = this.sldrInteriorHeight.getValueInt();
        if (sliderValue > 8) {
            sliderValue = 8;
        } else if (sliderValue < 3) {
            sliderValue = 3;
        }
        this.configuration.interiorHeight = sliderValue;
        this.configuration.houseFacing = this.player.func_174811_aO().func_176734_d();
        this.configuration.pos = this.pos;
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.chckIncludeRoof) {
            this.sldrInteriorHeight.field_146125_m = this.configuration.includeRoof = this.chckIncludeRoof.isChecked();
        }
        if (button == this.btnMaterialType) {
            this.configuration.bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(this.configuration.bridgeMaterial.getNumber() + 1);
            this.btnMaterialType.field_146126_j = this.configuration.bridgeMaterial.getTranslatedName();
        } else if (button == this.btnVisualize) {
            StructureInstantBridge structure = new StructureInstantBridge();
            structure.getClearSpace().getShape().setDirection(EnumFacing.SOUTH);
            structure.setupStructure(this.configuration, this.pos);
            this.performPreview(structure, this.configuration);
        }
    }
}

