/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookFolderLoader;

public class BookRegistry {
    public static final BookRegistry INSTANCE = new BookRegistry();
    public static final String BOOKS_LOCATION = "patchouli_books";
    public final Map<ResourceLocation, Book> books = new HashMap<ResourceLocation, Book>();
    public Gson gson = new GsonBuilder().create();

    private BookRegistry() {
    }

    public void init() {
        List mods = Loader.instance().getActiveModList();
        HashMap<Pair, String> foundBooks = new HashMap<Pair, String>();
        mods.forEach(mod -> {
            String id = mod.getModId();
            CraftingHelper.findFiles((ModContainer)mod, (String)String.format("assets/%s/%s", id, BOOKS_LOCATION), path -> Files.exists(path, new LinkOption[0]), (path, file) -> {
                if (file.toString().endsWith("book.json")) {
                    String fileStr = file.toString().replaceAll("\\\\", "/");
                    String relPath = fileStr.substring(fileStr.indexOf(BOOKS_LOCATION) + BOOKS_LOCATION.length() + 1);
                    String bookName = relPath.substring(0, relPath.indexOf("/"));
                    if (bookName.contains("/")) {
                        new IllegalArgumentException("Ignored book.json @ " + file).printStackTrace();
                        return true;
                    }
                    String assetPath = fileStr.substring(fileStr.indexOf("/assets"));
                    ResourceLocation bookId = new ResourceLocation(id, bookName);
                    foundBooks.put(Pair.of((Object)mod, (Object)bookId), assetPath);
                }
                return true;
            }, (boolean)false, (boolean)true);
        });
        foundBooks.forEach((pair, file) -> {
            ModContainer mod = (ModContainer)pair.getLeft();
            ResourceLocation res = (ResourceLocation)pair.getRight();
            InputStream stream = mod.getMod().getClass().getResourceAsStream((String)file);
            this.loadBook(mod, res, stream, false);
        });
        BookFolderLoader.findBooks();
    }

    public void loadBook(ModContainer mod, ResourceLocation res, InputStream stream, boolean external) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        Book book = (Book)this.gson.fromJson((Reader)reader, Book.class);
        this.books.put(res, book);
        book.build(mod, res, external);
    }

    @SideOnly(value=Side.CLIENT)
    public void reload() {
        this.books.values().forEach(Book::reloadContents);
        this.books.values().forEach(Book::reloadExtensionContents);
        ClientAdvancements.updateLockStatus(false);
    }
}

