/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.preprocessor;

import crafttweaker.api.network.NetworkSide;
import crafttweaker.preprocessor.PreprocessorActionBase;
import crafttweaker.runtime.ScriptFile;

public class SideOnlyPreprocessor
extends PreprocessorActionBase {
    public static final String PREPROCESSOR_NAME = "sideonly";
    private NetworkSide side;

    public SideOnlyPreprocessor(String fileName, String preprocessorLine, int lineIndex) {
        super(fileName, preprocessorLine, lineIndex);
        String sideName;
        String s = preprocessorLine.substring(PREPROCESSOR_NAME.length() + 1);
        switch (sideName = s.trim()) {
            case "client": {
                this.side = NetworkSide.SIDE_CLIENT;
                break;
            }
            case "server": {
                this.side = NetworkSide.SIDE_SERVER;
                break;
            }
            default: {
                this.side = NetworkSide.INVALID_SIDE;
            }
        }
    }

    @Override
    public void executeActionOnFind(ScriptFile scriptFile) {
        scriptFile.setNetworkSide(this.side);
    }

    @Override
    public String getPreprocessorName() {
        return PREPROCESSOR_NAME;
    }
}

