/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.item;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.creativetabs.ICreativeTab;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.mc1120.creativetabs.MCCreativeTab;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.Optional;

public class MCItemDefinition
implements IItemDefinition {
    private final String id;
    private final Item item;

    public MCItemDefinition(String id, Item item) {
        this.id = id;
        this.item = item;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.item.func_77658_a();
    }

    @Override
    public String getOwner() {
        return this.getId().split(":")[0];
    }

    @Override
    public IItemStack makeStack(@Optional int meta) {
        return CraftTweakerMC.getIItemStackWildcardSize(new ItemStack(this.item, 1, meta));
    }

    @Override
    public List<IOreDictEntry> getOres() {
        ArrayList<IOreDictEntry> result = new ArrayList<IOreDictEntry>();
        block0: for (String key : OreDictionary.getOreNames()) {
            for (ItemStack is : OreDictionary.getOres((String)key)) {
                if (is.func_77973_b() != this.item) continue;
                result.add(CraftTweakerAPI.oreDict.get(key));
                continue block0;
            }
        }
        return result;
    }

    @Override
    public IItemStack getDefaultInstance() {
        return new MCItemStack(this.item.func_190903_i());
    }

    @Override
    public void setHarvestLevel(String type, int level) {
        this.item.setHarvestLevel(type, level);
    }

    @Override
    public ICreativeTab getCreativeTab() {
        return MCCreativeTab.getICreativeTab(this.item.func_77640_w());
    }

    @Override
    public void setCreativeTab(ICreativeTab tab) {
        this.item.func_77637_a(CraftTweakerMC.getCreativeTabs(tab));
    }

    @Override
    public ICreativeTab[] getCreativeTabs() {
        CreativeTabs[] mcTabs = this.item.getCreativeTabs();
        ICreativeTab[] output = new ICreativeTab[mcTabs.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = MCCreativeTab.getICreativeTab(mcTabs[i]);
        }
        return output;
    }

    @Override
    public void setNoRepair() {
        this.item.setNoRepair();
    }

    @Override
    public boolean canItemEditBlocks() {
        return this.item.func_82788_x();
    }

    @Override
    public int getItemEnchantability() {
        return this.item.func_77619_b();
    }

    @Override
    public void setContainerItem(IItemDefinition itemDef) {
        this.item.func_77642_a((Item)itemDef.getInternal());
    }

    @Override
    public List<IItemStack> getSubItems() {
        return this.getSubItems(this.getCreativeTab());
    }

    @Override
    public List<IItemStack> getSubItems(ICreativeTab tab) {
        NonNullList list = NonNullList.func_191196_a();
        this.item.func_150895_a(tab == null ? CreativeTabs.field_78027_g : (CreativeTabs)tab.getInternal(), list);
        return list.stream().map(MCItemStack::new).collect(Collectors.toList());
    }

    @Override
    public int getItemBurnTime(IItemStack itemStack) {
        return this.item.getItemBurnTime(CraftTweakerMC.getItemStack(itemStack));
    }

    @Override
    public Object getInternal() {
        return this.item;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.item != null ? this.item.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MCItemDefinition other = (MCItemDefinition)obj;
        return Objects.equals(this.item, other.item);
    }
}

