/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.entity;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.entity.IEntityDrop;
import crafttweaker.api.entity.IEntityDropFunction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.entity.EntityDrop;
import crafttweaker.util.IntegerRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class MCEntityDefinition
implements IEntityDefinition {
    private final EntityEntry entityEntry;
    private final String entityName;
    private final List<IEntityDrop> drops = new ArrayList<IEntityDrop>();
    private final List<IItemStack> dropsToRemove = new ArrayList<IItemStack>();
    private List<IEntityDropFunction> dropFunctions = new ArrayList<IEntityDropFunction>();
    private boolean clearDrops = false;

    public MCEntityDefinition(EntityEntry entityEntry) {
        this.entityEntry = entityEntry;
        this.entityName = entityEntry.getName();
    }

    @Override
    public String getId() {
        return this.entityEntry.getRegistryName() != null ? this.entityEntry.getRegistryName().toString() : "no_registry_name";
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    @Override
    public void addDrop(IItemStack stack, int min, int max, float chance) {
        if (min < 0 || max < 0 || chance < 0.0f || chance > 1.0f) {
            CraftTweakerAPI.logError(String.format("Invalid value provided: <entity:%s>.addDrop(%s, %d, %d, %s).", this.entityName, stack, min, max, Float.valueOf(chance)));
            return;
        }
        this.drops.add(new EntityDrop(stack, min, max, chance));
    }

    @Override
    public void addDrop(WeightedItemStack stack, int min, int max) {
        this.addDrop(stack.getStack(), min, max, stack.getChance());
    }

    @Override
    public void addPlayerOnlyDrop(IItemStack stack, int min, int max, float chance) {
        if (min < 0 || max < 0 || chance < 0.0f || chance > 1.0f) {
            CraftTweakerAPI.logError(String.format("Invalid value provided: <entity:%s>.addPlayerOnlyDrop(%s, %d, %d, %s).", this.entityName, stack, min, max, Float.valueOf(chance)));
            return;
        }
        this.drops.add(new EntityDrop(stack, min, max, chance, true));
    }

    @Override
    public void addPlayerOnlyDrop(WeightedItemStack stack, int min, int max) {
        this.addPlayerOnlyDrop(stack.getStack(), min, max, stack.getChance());
    }

    @Override
    public void removeDrop(IItemStack stack) {
        this.dropsToRemove.add(stack);
    }

    @Override
    public void clearDrops() {
        this.clearDrops = true;
    }

    @Override
    public List<IEntityDrop> getDrops() {
        return this.drops;
    }

    @Override
    public IEntity createEntity(IWorld world) {
        return CraftTweakerMC.getIEntity(this.entityEntry.newInstance(CraftTweakerMC.getWorld(world)));
    }

    @Override
    public IEntity spawnEntity(IWorld world, IBlockPos pos) {
        IEntity out = this.createEntity(world);
        out.setPosition(pos);
        world.spawnEntity(out);
        return out;
    }

    @Override
    public Map<IItemStack, IntegerRange> getDropsToAdd() {
        return this.drops.stream().filter(drop -> !drop.isPlayerOnly()).collect(Collectors.toMap(IEntityDrop::getItemStack, IEntityDrop::getRange));
    }

    @Override
    public Map<IItemStack, IntegerRange> getDropsToAddPlayerOnly() {
        return this.drops.stream().filter(IEntityDrop::isPlayerOnly).collect(Collectors.toMap(IEntityDrop::getItemStack, IEntityDrop::getRange));
    }

    @Override
    public List<IItemStack> getDropsToRemove() {
        return this.dropsToRemove;
    }

    @Override
    public boolean shouldClearDrops() {
        return this.clearDrops;
    }

    @Override
    public Object getInternal() {
        return this.entityEntry;
    }

    public String toString() {
        return "<entity:" + this.entityName + ">";
    }

    @Override
    public void addDropFunction(IEntityDropFunction function) {
        this.dropFunctions.add(function);
    }

    @Override
    public List<IEntityDropFunction> getDropFunctions() {
        return this.dropFunctions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCEntityDefinition that = (MCEntityDefinition)o;
        return Objects.equals(this.entityEntry, that.entityEntry);
    }

    public int hashCode() {
        return Objects.hash(this.entityEntry);
    }
}

