/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.recipe.advanced;

import gnu.trove.map.hash.TCharObjectHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import wanion.lib.recipe.advanced.IAdvancedRecipe;

public abstract class AbstractShapedAdvancedRecipe
implements IAdvancedRecipe {
    public final List<Object> inputs;
    public final int squareRoot;
    private final ItemStack output;
    private final short recipeKey;
    private final short recipeSize;
    private final short width;
    private final short height;

    public AbstractShapedAdvancedRecipe(int squareRoot, @Nonnull ItemStack output, Object ... inputs) {
        String code;
        int y;
        this.squareRoot = squareRoot;
        this.output = output.func_77946_l();
        int dictionaryIndex = 0;
        int height = 0;
        int width = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (!(inputs[i] instanceof String)) {
                dictionaryIndex = i;
                break;
            }
            height = (short)(height + 1);
        }
        if (dictionaryIndex == 0 || dictionaryIndex > squareRoot) {
            throw new RuntimeException("dictionary index is either zero or above the Square Root.");
        }
        TCharObjectHashMap charDictionary = new TCharObjectHashMap();
        for (int i = dictionaryIndex; i < inputs.length; ++i) {
            charDictionary.put(((Character)inputs[i]).charValue(), inputs[++i]);
        }
        int offSetX = 0;
        boolean found = false;
        for (int x = 0; !found && x < squareRoot; ++x) {
            for (y = 0; !found && y < height; ++y) {
                String code2 = (String)inputs[y];
                if (x >= code2.length() || charDictionary.get(code2.charAt(x)) == null) continue;
                found = true;
            }
            if (!found) continue;
            offSetX = x;
        }
        int offSetY = 0;
        boolean found2 = false;
        for (y = 0; !found2 && y < height; ++y) {
            for (int x = 0; x < squareRoot; ++x) {
                String code3 = (String)inputs[y];
                if (x < code3.length() && charDictionary.get(code3.charAt(x)) != null) {
                    found2 = true;
                }
                if (!found2) continue;
                offSetY = y;
            }
        }
        int oldHeight = height;
        height = 0;
        for (y = 0; y < oldHeight; ++y) {
            int actualX;
            int actualY;
            int x = 0;
            while ((actualY = offSetY + y) < oldHeight && (actualX = offSetX + x++) < (code = (String)inputs[actualY]).length()) {
                if (charDictionary.get(code.charAt(actualX)) == null) continue;
                int xDifference = actualX - (offSetX - 1);
                int yDifference = actualY - (offSetY - 1);
                if (xDifference > width) {
                    width = (short)xDifference;
                }
                if (yDifference <= height) continue;
                height = (short)yDifference;
            }
        }
        this.inputs = NonNullList.func_191197_a((int)(height * width), (Object)ItemStack.field_190927_a);
        this.width = (short)width;
        this.height = (short)height;
        short recipeSize = 0;
        for (int y2 = 0; y2 < height; ++y2) {
            int actualY = offSetY + y2;
            code = (String)inputs[actualY];
            for (int x = 0; x < width; ++x) {
                Object input;
                int actualX = offSetX + x;
                if (actualX >= code.length() || !((input = charDictionary.get(code.charAt(actualX))) instanceof ItemStack) && !(input instanceof String) && !(input instanceof List)) continue;
                int pos = width * y2 + x;
                if (input instanceof ItemStack) {
                    if (!((ItemStack)input).func_190926_b()) {
                        ((ItemStack)input).func_190920_e(1);
                        this.inputs.set(pos, input);
                    }
                } else if (input instanceof String) {
                    NonNullList oreList = OreDictionary.getOres((String)((String)input), (boolean)false);
                    if (oreList != null && !oreList.isEmpty()) {
                        this.inputs.set(pos, oreList);
                    }
                } else if (!((List)input).isEmpty() && ((List)input).get(0) instanceof ItemStack) {
                    this.inputs.set(pos, input);
                }
                if (this.inputs.get(pos) instanceof ItemStack && ((ItemStack)this.inputs.get(pos)).func_190926_b()) continue;
                recipeSize = (short)(recipeSize + 1);
            }
        }
        this.recipeSize = recipeSize;
        this.recipeKey = (short)(this.recipeSize | width << 8 | height << 12);
    }

    @Override
    public boolean isShaped() {
        return true;
    }

    @Override
    public short getRecipeKey() {
        return this.recipeKey;
    }

    @Override
    public short getRecipeSize() {
        return this.recipeSize;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @Nonnull
    public List<Object> getInputs() {
        return this.inputs;
    }

    @Override
    @Nonnull
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public boolean recipeMatches(@Nonnull InventoryCrafting inventoryCrafting, int offSetX, int offSetY) {
        return this.recipeMatches(inventoryCrafting, offSetX, offSetY, false) || this.recipeMatches(inventoryCrafting, offSetX, offSetY, true);
    }

    private boolean recipeMatches(@Nonnull InventoryCrafting inventoryCrafting, int offSetX, int offSetY, boolean mirror) {
        boolean matches = true;
        for (int y = 0; matches && y < this.height; ++y) {
            int actualY = offSetY + y;
            for (int x = 0; matches && x < this.width; ++x) {
                int actualX = mirror ? offSetX + x : offSetX + this.width - x - 1;
                Object input = this.inputs.get(y * this.width + x);
                ItemStack slotItemStack = inventoryCrafting.func_70301_a(actualY * this.squareRoot + actualX);
                if (!(!slotItemStack.func_190926_b() || input instanceof ItemStack && ((ItemStack)input).func_190926_b())) {
                    matches = false;
                }
                if (!matches) continue;
                if (input instanceof List) {
                    boolean found = false;
                    List inputList = (List)input;
                    for (Object object : inputList) {
                        if (found) break;
                        if (!(object instanceof ItemStack) || ((ItemStack)object).func_77973_b() != slotItemStack.func_77973_b() || ((ItemStack)object).func_77952_i() != Short.MAX_VALUE && ((ItemStack)object).func_77952_i() != slotItemStack.func_77952_i()) continue;
                        found = true;
                    }
                    if (found) {
                        continue;
                    }
                } else if (input instanceof ItemStack && (((ItemStack)input).func_77942_o() && ((ItemStack)input).func_77973_b() == slotItemStack.func_77973_b() && (!((ItemStack)input).func_77981_g() || ((ItemStack)input).func_77952_i() == slotItemStack.func_77952_i()) && ItemStack.func_77970_a((ItemStack)((ItemStack)input), (ItemStack)slotItemStack) || ((ItemStack)input).func_77973_b() == slotItemStack.func_77973_b() && (!((ItemStack)input).func_77981_g() || ((ItemStack)input).func_77952_i() == Short.MAX_VALUE || ((ItemStack)input).func_77952_i() == slotItemStack.func_77952_i()))) continue;
                matches = false;
            }
        }
        return matches;
    }
}

