/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import net.malisis.core.block.IComponent;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.block.BigDoor;
import net.malisis.doors.tileentity.BigDoorTileEntity;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class BigDoorRenderer
extends MalisisRenderer<BigDoorTileEntity> {
    private ResourceLocation rl;
    private MalisisModel model;
    private Shape frame;
    private Shape doorLeft;
    private Shape doorRight;
    private RenderParameters rp;
    private AnimationRenderer ar = new AnimationRenderer();
    private EnumFacing direction;

    public BigDoorRenderer() {
        this.registerFor(BigDoorTileEntity.class);
    }

    protected void initialize() {
        this.rl = new ResourceLocation("malisisdoors", "models/big_door.obj");
        this.model = new MalisisModel(this.rl);
        this.frame = this.model.getShape("Frame");
        this.doorLeft = this.model.getShape("Left");
        this.doorRight = this.model.getShape("Right");
        this.rp = new RenderParameters();
        this.rp.useBlockBounds.set((Object)false);
        this.rp.useEnvironmentBrightness.set((Object)false);
    }

    public void render() {
        if (this.tileEntity == null) {
            return;
        }
        this.setup();
        if (this.renderType == RenderType.BLOCK) {
            this.renderBlock();
        } else if (this.renderType == RenderType.TILE_ENTITY) {
            this.renderTileEntity();
        }
    }

    private void renderBlock() {
        IBlockState state = ((BigDoorTileEntity)this.tileEntity).getFrameState();
        if (!state.func_177230_c().canRenderInLayer(state, BigDoorRenderer.getRenderLayer())) {
            return;
        }
        this.rp.icon.set((Object)Icon.from((IBlockState)state));
        this.frame.applyMatrix();
        this.frame.deductParameters();
        this.set(state);
        this.drawShape(this.frame, this.rp);
    }

    private void renderTileEntity() {
        this.ar.setStartTime(((BigDoorTileEntity)this.tileEntity).getTimer().getStart());
        if (((BigDoorTileEntity)this.tileEntity).getMovement() != null) {
            Animation<?>[] anims = ((BigDoorTileEntity)this.tileEntity).getMovement().getAnimations((DoorTileEntity)this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        this.rp.icon.set((Object)((BigDoor.BigDoorIconProvider)IComponent.getComponent(BigDoor.BigDoorIconProvider.class, (Object)this.block)).getDoorIcon());
        this.drawShape(this.doorLeft, this.rp);
        this.drawShape(this.doorRight, this.rp);
    }

    private void setup() {
        this.direction = ((BigDoorTileEntity)this.tileEntity).getDirection();
        this.model.resetState();
        if (this.direction == EnumFacing.NORTH) {
            this.model.rotate(180.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (this.direction == EnumFacing.EAST) {
            this.model.rotate(90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (this.direction == EnumFacing.WEST) {
            this.model.rotate(-90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.rp.brightness.set((Object)this.blockState.func_185889_a(this.world, this.pos));
    }
}

