/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;

public class SyncableFloat
extends SyncableObjectBase
implements ISyncableValueProvider<Float> {
    public static final float EPSILON = 1.0E-4f;
    private float value;

    public SyncableFloat(float value) {
        this.value = value;
    }

    public SyncableFloat() {
    }

    public void set(float newValue) {
        if (!this.equals(newValue)) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public float get() {
        return this.value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public boolean equals(float otherValue) {
        return Math.abs(otherValue - this.value) < 1.0E-4f;
    }

    @Override
    public void readFromStream(PacketBuffer stream) {
        this.value = stream.readFloat();
    }

    @Override
    public void writeToStream(PacketBuffer stream) {
        stream.writeFloat(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74776_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74760_g(name);
    }

    public void modify(float by) {
        this.set(this.value + by);
    }
}

