/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SingleFluidBucketFillHandler {
    @GameRegistry.ObjectHolder(value="minecraft:bucket")
    private static final Item EMPTY_BUCKET = null;
    @Nonnull
    private final ItemStack filledBucket;
    private final FluidStack containedFluid;

    public SingleFluidBucketFillHandler(@Nonnull ItemStack filledBucket) {
        this.filledBucket = filledBucket;
        this.containedFluid = FluidUtil.getFluidContained((ItemStack)filledBucket);
        Preconditions.checkState((this.containedFluid != null ? 1 : 0) != 0, (String)"Item %s is not a filled bucket", (Object)filledBucket);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBucketFill(FillBucketEvent evt) {
        IFluidHandler source;
        FluidStack drained;
        if (evt.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (evt.getEmptyBucket().func_77973_b() != EMPTY_BUCKET) {
            return;
        }
        RayTraceResult target = evt.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        TileEntity te = evt.getWorld().func_175625_s(target.func_178782_a());
        if (te == null) {
            return;
        }
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, target.field_178784_b) && this.containedFluid.isFluidStackIdentical(drained = (source = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, target.field_178784_b)).drain(this.containedFluid, false))) {
            source.drain(this.containedFluid, true);
            evt.setFilledBucket(this.filledBucket.func_77946_l());
            evt.setResult(Event.Result.ALLOW);
        }
    }
}

