/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class GenericFluidCapabilityWrapper
implements IFluidHandler {
    private final IFluidHandler tank;

    public GenericFluidCapabilityWrapper(IFluidHandler tank) {
        this.tank = tank;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFill(resource.getFluid())) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(resource.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.canDrain(null)) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    protected boolean canFill(Fluid fluid) {
        return true;
    }

    protected boolean canDrain(Fluid fluid) {
        return true;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public static class Drain
    extends GenericFluidCapabilityWrapper {
        public Drain(IFluidHandler tank) {
            super(tank);
        }

        @Override
        public boolean canDrain(Fluid fluid) {
            return false;
        }

        @Override
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Override
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }

    public static class Source
    extends GenericFluidCapabilityWrapper {
        public Source(IFluidHandler tank) {
            super(tank);
        }

        @Override
        public boolean canFill(Fluid fluid) {
            return false;
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }
    }
}

