/*
 * Decompiled with CFR 0.152.
 */
package openmods.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.List;
import net.minecraft.item.ItemStack;
import openmods.inventory.comparator.ComparatorComponents;

public class StackComparatorBuilder {
    private List<Ordering<ItemStack>> result = Lists.newArrayList();
    private boolean usedItem;
    private boolean usedItemId;
    private boolean usedDamage;
    private boolean usedSize;

    public StackComparatorBuilder useItem() {
        Preconditions.checkState((!this.usedItem ? 1 : 0) != 0);
        this.usedItem = true;
        this.result.add(ComparatorComponents.ITEM_COMPARATOR);
        return this;
    }

    public StackComparatorBuilder useItemId() {
        Preconditions.checkState((!this.usedItemId ? 1 : 0) != 0);
        this.usedItemId = true;
        this.result.add(ComparatorComponents.ITEM_ID_COMPARATOR);
        return this;
    }

    public StackComparatorBuilder useDamage() {
        Preconditions.checkState((!this.usedDamage ? 1 : 0) != 0);
        this.usedDamage = true;
        this.result.add(ComparatorComponents.DAMAGE_COMPARATOR);
        return this;
    }

    public StackComparatorBuilder useSize() {
        Preconditions.checkState((!this.usedSize ? 1 : 0) != 0);
        this.usedSize = true;
        this.result.add(ComparatorComponents.SIZE_COMPARATOR);
        return this;
    }

    public Ordering<ItemStack> build() {
        return Ordering.compound(this.result);
    }
}

