/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import openmods.Log;
import openmods.calc.HelpPrinter;
import openmods.calc.ICommandComponent;
import openmods.calc.IWhitespaceSplitter;
import openmods.calc.NestedCommandException;
import openmods.calc.WhitespaceSplitters;

public class CommandCalc
implements ICommand {
    protected final String name;
    private final ICommandComponent commandComponent;
    private final List<String> aliases;

    public CommandCalc(ICommandComponent parentCommandComponent, String name, String ... aliases) {
        this.name = "=" + name;
        this.aliases = Arrays.asList(aliases);
        this.commandComponent = parentCommandComponent.partialyExecute(WhitespaceSplitters.fromSplitArray(name));
    }

    public int compareTo(ICommand o) {
        return this.name.compareTo(o.func_71517_b());
    }

    public String func_71517_b() {
        return this.name;
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public String func_71518_a(ICommandSender sender) {
        HelpPrinter printer = new HelpPrinter();
        printer.push(this.name);
        this.commandComponent.help(printer);
        return printer.generate();
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return this.commandComponent.getTabCompletions(WhitespaceSplitters.fromSplitArray(args));
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IWhitespaceSplitter splitArgs = WhitespaceSplitters.fromSplitArray(args);
        try {
            this.commandComponent.execute(sender, splitArgs);
        }
        catch (NestedCommandException e) {
            e.pushCommandName(this.name);
            ITextComponent message = e.getChatComponent();
            message.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_145747_a(message);
        }
        catch (Exception e) {
            Log.info(e, "Failed to execute command", new Object[0]);
            ArrayList causes = Lists.newArrayList();
            for (Throwable current = e; current != null; current = current.getCause()) {
                causes.add(Strings.nullToEmpty((String)current.getMessage()));
            }
            throw new CommandException("openmodslib.command.calc_error", new Object[]{Joiner.on((String)"', caused by '").join((Iterable)causes)});
        }
        if (!splitArgs.isFinished()) {
            throw new CommandException("openmodslib.command.calc_extra_args", new Object[]{splitArgs.getTail()});
        }
    }
}

