/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.nmsot;

import com.mmyzd.nmsot.NoMobSpawningOnTrees;
import com.mmyzd.nmsot.rule.RuleSet;
import java.io.File;
import java.util.HashMap;
import net.minecraft.entity.EnumCreatureType;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;

public class ConfigManager {
    public Configuration file;
    public Property extraSpawningTries;
    public Property spawnCapacityMonster;
    public Property spawnCapacityAnimal;
    public Property spawnCapacityAmbient;
    public Property spawnCapacityWater;
    public Property blacklistRules;
    HashMap<String, Integer> capacityBackup = new HashMap();

    public ConfigManager(File configDir) {
        this.file = new Configuration(new File(configDir, "NoMobSpawningOnTrees.cfg"));
        this.reload();
    }

    @SubscribeEvent
    public void onConfigurationChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("nmsot")) {
            this.update();
        }
    }

    void reload() {
        this.file.load();
        this.extraSpawningTries = this.file.get("general", "extraSpawningTries", 0.0);
        this.extraSpawningTries.setComment("Extra spawning tries per tick. This will only applies to hostile mobs.");
        this.spawnCapacityMonster = this.file.get("general", "spawnCapacityMonster", -1);
        this.spawnCapacityAnimal = this.file.get("general", "spawnCapacityAnimal", -1);
        this.spawnCapacityAmbient = this.file.get("general", "spawnCapacityAmbient", -1);
        this.spawnCapacityWater = this.file.get("general", "spawnCapacityWater", -1);
        String comment = "The capacity is the maximum (approximate) number of creatures can exist near the player.";
        comment = comment + "\nSet -1 to use the default value, which is: monster(70), animal(10), ambient(15), water(5)";
        this.spawnCapacityAmbient.setComment(comment);
        this.blacklistRules = this.file.get("general", "blacklistRules", new String[]{"woodlogs    # This line disables mob spawning on all types of wood logs.", "block:minecraft:brown_mushroom_block || block:minecraft:red_mushroom_block", "# The above line disables mob spawning on mushroom blocks."});
        this.blacklistRules.setComment("For details, please check https://github.com/oldjunyi/NoMobSpawningOnTrees/wiki");
        this.update();
    }

    public void update() {
        this.extraSpawningTries.set(Math.min(Math.max(this.extraSpawningTries.getDouble(0.0), 0.0), 10000.0));
        this.spawnCapacityMonster.set(Math.min(Math.max(this.spawnCapacityMonster.getInt(), -1), 10000));
        this.spawnCapacityAnimal.set(Math.min(Math.max(this.spawnCapacityAnimal.getInt(), -1), 10000));
        this.spawnCapacityAmbient.set(Math.min(Math.max(this.spawnCapacityAmbient.getInt(), -1), 10000));
        this.spawnCapacityWater.set(Math.min(Math.max(this.spawnCapacityWater.getInt(), -1), 10000));
        this.updateSpawnCapacity(EnumCreatureType.MONSTER, this.spawnCapacityMonster.getInt());
        this.updateSpawnCapacity(EnumCreatureType.CREATURE, this.spawnCapacityAnimal.getInt());
        this.updateSpawnCapacity(EnumCreatureType.AMBIENT, this.spawnCapacityAmbient.getInt());
        this.updateSpawnCapacity(EnumCreatureType.WATER_CREATURE, this.spawnCapacityWater.getInt());
        if (NoMobSpawningOnTrees.instance.rules != null) {
            NoMobSpawningOnTrees.instance.rules = new RuleSet(this.blacklistRules.getStringList());
        }
        this.file.save();
    }

    void updateSpawnCapacity(EnumCreatureType e, int cur) {
        try {
            if (cur == -1) {
                Integer old = this.capacityBackup.get(e.name());
                if (old == null) {
                    return;
                }
                ObfuscationReflectionHelper.setPrivateValue(EnumCreatureType.class, (Object)e, (Object)old, (String[])new String[]{"maxNumberOfCreature", "field_75606_e"});
                this.capacityBackup.remove(e.name());
            } else {
                Integer old = this.capacityBackup.get(e.name());
                if (old == null) {
                    this.capacityBackup.put(e.name(), e.func_75601_b());
                }
                ObfuscationReflectionHelper.setPrivateValue(EnumCreatureType.class, (Object)e, (Object)cur, (String[])new String[]{"maxNumberOfCreature", "field_75606_e"});
            }
        }
        catch (Exception c) {
            LogManager.getLogger((String)"nmsot").info("Failed to set spawn capacity for " + e.name());
        }
    }
}

