/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import slimeknights.tconstruct.gadgets.tileentity.TileItemRack;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.tileentity.IProgress;

public class TileDryingRack
extends TileItemRack
implements ITickable,
ISidedInventory,
IProgress {
    private static final String TAG_TIME = "Time";
    private static final String TAG_MAXTIME = "MaxTime";
    int currentTime;
    int maxTime;

    public TileDryingRack() {
        super("gui.dryingrack.name", 2);
        this.itemHandler = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    }

    @Override
    public float getProgress() {
        if (!this.func_70301_a(0).func_190926_b() && this.currentTime < this.maxTime) {
            return (float)this.currentTime / (float)this.maxTime;
        }
        return 0.0f;
    }

    public void func_73660_a() {
        if (this.maxTime > 0 && this.currentTime < this.maxTime) {
            ++this.currentTime;
            if (this.currentTime >= this.maxTime && !this.func_145831_w().field_72995_K) {
                this.func_70299_a(1, TinkerRegistry.getDryingResult(this.func_70301_a(0)));
                this.func_70299_a(0, ItemStack.field_190927_a);
                this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            }
        }
    }

    @Override
    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        if (slot == 0 && !this.isStackInSlot(1) && !stack.func_190926_b() && TinkerRegistry.getDryingResult(stack) == null) {
            slot = 1;
        }
        super.func_70299_a(slot, stack);
        if (slot == 0) {
            this.updateDryingTime();
        } else if (this.func_145831_w() != null) {
            this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        }
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        this.maxTime = 0;
        this.currentTime = 0;
        return stack;
    }

    public void updateDryingTime() {
        this.currentTime = 0;
        ItemStack stack = this.func_70301_a(0);
        this.maxTime = !stack.func_190926_b() ? TinkerRegistry.getDryingTime(stack) : -1;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() - 1), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return index == 0 && !this.isStackInSlot(1);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return index == 1;
    }

    public int comparatorStrength() {
        return this.isStackInSlot(1) ? 15 : 0;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.currentTime = tags.func_74762_e(TAG_TIME);
        this.maxTime = tags.func_74762_e(TAG_MAXTIME);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        tags.func_74768_a(TAG_TIME, this.currentTime);
        tags.func_74768_a(TAG_MAXTIME, this.maxTime);
        return tags;
    }
}

