/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.world;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NeighborUpdateCollector {
    protected final World world;
    private final HashSet<BlockPos> blocksToUpdate;

    public NeighborUpdateCollector(World world, Collection<BlockPos> positions) {
        this.world = world;
        this.blocksToUpdate = new HashSet<BlockPos>(positions);
    }

    public NeighborUpdateCollector(World world) {
        this.world = world;
        this.blocksToUpdate = new HashSet();
    }

    public void add(BlockPos pos) {
        this.blocksToUpdate.add(pos);
    }

    public void add(TileEntity te) {
        this.blocksToUpdate.add(te.func_174877_v());
    }

    public void add(Collection<BlockPos> positions) {
        this.blocksToUpdate.addAll(positions);
    }

    protected void processPosition(BlockPos pos, HashSet<BlockPos> notifiedBlocks) {
        IBlockState origin = this.world.func_180495_p(pos);
        for (int i = 0; i < 6; ++i) {
            BlockPos neighbour = pos.func_177972_a(EnumFacing.field_82609_l[i]);
            if (notifiedBlocks.contains(neighbour) || this.blocksToUpdate.contains(neighbour)) continue;
            this.world.func_180495_p(neighbour).func_189546_a(this.world, neighbour, origin.func_177230_c(), pos);
            notifiedBlocks.add(neighbour);
        }
    }

    public void process() {
        HashSet<BlockPos> notifiedBlocks = new HashSet<BlockPos>();
        for (BlockPos pos : this.blocksToUpdate) {
            this.processPosition(pos, notifiedBlocks);
        }
        this.blocksToUpdate.clear();
    }
}

