/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.world;

import com.creativemd.creativecore.client.rendering.IRenderChunkSupplier;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CreativeWorld
extends World
implements IOrientatedWorld {
    public Entity parent;
    @SideOnly(value=Side.CLIENT)
    public IRenderChunkSupplier renderChunkSupplier;
    public boolean hasChanged = false;
    public boolean preventNeighborUpdate = false;

    protected CreativeWorld(ISaveHandler saveHandlerIn, WorldInfo info, WorldProvider providerIn, Profiler profilerIn, boolean client) {
        super(saveHandlerIn, info, providerIn, profilerIn, client);
    }

    public void func_190524_a(BlockPos pos, final Block blockIn, BlockPos fromPos) {
        if (this.preventNeighborUpdate) {
            return;
        }
        if (this.field_72995_K) {
            IBlockState iblockstate = this.func_180495_p(pos);
            try {
                iblockstate.func_189546_a((World)this, pos, blockIn, fromPos);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
                crashreportcategory.func_189529_a("Source block type", (ICrashReportDetail)new ICrashReportDetail<String>(){

                    public String call() throws Exception {
                        try {
                            return String.format("ID #%d (%s // %s // %s)", Block.func_149682_b((Block)blockIn), blockIn.func_149739_a(), blockIn.getClass().getName(), blockIn.getRegistryName());
                        }
                        catch (Throwable var2) {
                            return "ID #" + Block.func_149682_b((Block)blockIn);
                        }
                    }
                });
                CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (IBlockState)iblockstate);
                throw new ReportedException(crashreport);
            }
        } else {
            super.func_190524_a(pos, blockIn, fromPos);
        }
    }

    public void func_175685_c(BlockPos pos, Block blockType, boolean updateObservers) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.func_175685_c(pos, blockType, updateObservers);
    }

    public void func_175695_a(BlockPos pos, Block blockType, EnumFacing skipSide) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.func_175695_a(pos, blockType, skipSide);
    }

    public void func_175722_b(BlockPos pos, Block blockType, boolean p_175722_3_) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.func_175722_b(pos, blockType, p_175722_3_);
    }

    public BlockPos transformToRealWorld(BlockPos pos) {
        return new BlockPos(this.getOrigin().transformPointToWorld(new Vec3d((Vec3i)pos)));
    }

    public void func_175669_a(int id, BlockPos pos, int data) {
        if (this.getOrigin() == null) {
            return;
        }
        this.getRealWorld().func_175669_a(id, this.transformToRealWorld(pos), data);
    }

    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = new Vector3d(x, y, z);
        this.getOrigin().transformPointToWorld(vec);
        this.getRealWorld().func_184134_a(vec.x, vec.y, vec.z, soundIn, category, volume, pitch, distanceDelay);
    }

    public void func_184133_a(EntityPlayer player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        if (this.getOrigin() == null) {
            return;
        }
        this.getRealWorld().func_184133_a(player, this.transformToRealWorld(pos), soundIn, category, volume, pitch);
    }

    public void func_184148_a(EntityPlayer player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = new Vector3d(x, y, z);
        this.getOrigin().transformPointToWorld(vec);
        this.getRealWorld().func_184148_a(player, x, y, z, soundIn, category, volume, pitch);
    }

    public void func_184149_a(BlockPos blockPositionIn, SoundEvent soundEventIn) {
        if (this.getOrigin() == null) {
            return;
        }
        this.getRealWorld().func_184149_a(this.transformToRealWorld(blockPositionIn), soundEventIn);
    }
}

