/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.collision;

import com.creativemd.creativecore.common.utils.math.VectorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;

public class IntersectionHelperAdvanced {
    public static final int EDGE_Y_0 = 2;
    public static final int EDGE_X_1 = 4;
    public static final int EDGE_Y_1 = 6;
    public static final int EDGE_X_0 = 8;
    public static final int EDGE_EDGE_OFFSET = 2;
    public static final int CORNER_CORNER_OFFSET = 2;
    public static final int CORNER_EDGE_OFFSET = 1;
    public static final int cornerArrayLength = 4;
    public static final int VXX_STEP_SIZE = 2;
    public static final int NONE = 0;

    public static List<Vector2f> getIntersectionShape(float minX, float minY, float maxX, float maxY, EnumFacing.Axis one, EnumFacing.Axis two, Vector3f[] corners) {
        int ci;
        float originOne = VectorUtils.get(one, (Tuple3f)corners[1]);
        float originTwo = VectorUtils.get(two, (Tuple3f)corners[1]);
        boolean inversed = (VectorUtils.get(one, (Tuple3f)corners[0]) - originOne) * (VectorUtils.get(two, (Tuple3f)corners[2]) - originTwo) - (VectorUtils.get(two, (Tuple3f)corners[0]) - originTwo) * (VectorUtils.get(one, (Tuple3f)corners[2]) - originOne) < 0.0f;
        List<Vector2f> result = new ArrayList<Vector2f>(8);
        Vector2f prev = inversed ? new Vector2f(VectorUtils.get(one, (Tuple3f)corners[0]), VectorUtils.get(two, (Tuple3f)corners[0])) : new Vector2f(VectorUtils.get(one, (Tuple3f)corners[corners.length - 1]), VectorUtils.get(two, (Tuple3f)corners[corners.length - 1]));
        Vector2f cur = null;
        int cornerCount = 0;
        int lastIntersectingEdge = 0;
        int firstCornerCount = 0;
        Ray ray = new Ray();
        int n = ci = inversed ? corners.length : 0;
        while (inversed ? ci-- > 0 : ci < corners.length) {
            cur = new Vector2f(VectorUtils.get(one, (Tuple3f)corners[ci]), VectorUtils.get(two, (Tuple3f)corners[ci]));
            ray.reset();
            if (prev.x < minX && cur.x < minX || prev.x > maxX && cur.x > maxX || prev.y < minY && cur.y < minY || prev.y > maxY && cur.y > maxY) {
                cornerCount += IntersectionHelperAdvanced.getCornerCount(minX, minY, maxX, maxY, lastIntersectingEdge, 0, ray, prev, cur);
                if (result.isEmpty()) {
                    firstCornerCount = cornerCount;
                }
                prev = cur;
            } else {
                int i;
                float angleCurrent;
                float angleCorner;
                ArrayList<Integer> intersections = new ArrayList<Integer>(2);
                ArrayList<Vector2f> postfix = new ArrayList<Vector2f>(2);
                if (prev.x < minX || prev.x > maxX) {
                    if (prev.y < minY || prev.y > maxY) {
                        angleCorner = IntersectionHelperAdvanced.angle(prev, IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, prev));
                        if (IntersectionHelperAdvanced.epsilionGreater(angleCorner, angleCurrent = IntersectionHelperAdvanced.angle(prev, cur))) {
                            if (!(IntersectionHelperAdvanced.epsilionEqualsSmaller(minX, cur.x) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.x, maxX) && IntersectionHelperAdvanced.epsilionEquals(cur.y, prev.y < minY ? minY : maxY))) {
                                intersections.add(prev.y < minY ? 8 : 4);
                            }
                        } else if (IntersectionHelperAdvanced.epsilionSmaller(angleCorner, angleCurrent)) {
                            if (!(IntersectionHelperAdvanced.epsilionEqualsSmaller(minY, cur.y) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, maxY) && IntersectionHelperAdvanced.epsilionEquals(cur.x, prev.x < minX ? minX : maxY))) {
                                intersections.add(prev.x < minX ? 2 : 6);
                            }
                        } else {
                            postfix.add(IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, prev));
                        }
                        if (cur.x < minX || cur.x > maxX || cur.y < minY || cur.y > maxY) {
                            angleCorner = IntersectionHelperAdvanced.angle(prev, IntersectionHelperAdvanced.getOpositeClosestNormalCorner(minX, minY, maxX, maxY, prev));
                            if (IntersectionHelperAdvanced.epsilionGreater(angleCorner, angleCurrent)) {
                                if (!(IntersectionHelperAdvanced.epsilionEqualsSmaller(minY, cur.y) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, maxY) && IntersectionHelperAdvanced.epsilionEquals(cur.x, prev.x < minX ? maxX : minX))) {
                                    intersections.add(prev.x < minX ? 6 : 2);
                                }
                            } else if (IntersectionHelperAdvanced.epsilionSmaller(angleCorner, angleCurrent)) {
                                if (!(IntersectionHelperAdvanced.epsilionEqualsSmaller(minX, cur.x) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.x, maxX) && IntersectionHelperAdvanced.epsilionEquals(cur.y, prev.y < minY ? maxY : minY))) {
                                    intersections.add(prev.y < minY ? 4 : 8);
                                }
                            } else {
                                postfix.add(IntersectionHelperAdvanced.getOpositeClosestNormalCorner(minX, minY, maxX, maxY, prev));
                            }
                        }
                    } else if (IntersectionHelperAdvanced.epsilionEquals(prev.y, minY) && IntersectionHelperAdvanced.epsilionEquals(cur.y, minY) || IntersectionHelperAdvanced.epsilionEquals(prev.y, maxY) && IntersectionHelperAdvanced.epsilionEquals(cur.y, maxY)) {
                        if (!(IntersectionHelperAdvanced.epsilionEqualsSmaller(minX, prev.x) && IntersectionHelperAdvanced.epsilionEqualsSmaller(prev.x, maxX) && IntersectionHelperAdvanced.epsilionEqualsSmaller(minY, prev.y) && IntersectionHelperAdvanced.epsilionEqualsSmaller(prev.y, maxY) || prev.x < minX && IntersectionHelperAdvanced.epsilionEquals(cur.x, minX) || prev.x > maxX && IntersectionHelperAdvanced.epsilionEquals(cur.x, maxX))) {
                            postfix.add(IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, prev));
                        }
                        if (!(IntersectionHelperAdvanced.epsilionEqualsSmaller(minX, cur.x) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.x, maxX) && IntersectionHelperAdvanced.epsilionEqualsSmaller(minY, cur.y) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, maxY) || cur.x < minX && IntersectionHelperAdvanced.epsilionEquals(prev.x, minX) || cur.x > maxX && IntersectionHelperAdvanced.epsilionEquals(prev.x, maxX))) {
                            postfix.add(IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, cur));
                        }
                    } else if (prev.x < minX && !IntersectionHelperAdvanced.epsilionEquals(cur.x, minX) || prev.x > maxX && !IntersectionHelperAdvanced.epsilionEquals(cur.x, maxX)) {
                        intersections.add(prev.x < minX ? 2 : 6);
                        if (cur.x < minX || cur.x > maxX) {
                            if (IntersectionHelperAdvanced.epsilionEqualsSmaller(minY, cur.y) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, maxY) && !IntersectionHelperAdvanced.epsilionEquals(cur.x, prev.x < minX ? maxX : minX)) {
                                intersections.add(cur.x < minX ? 2 : 6);
                            } else {
                                angleCorner = IntersectionHelperAdvanced.angle(prev, IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, cur));
                                if (angleCorner > (angleCurrent = IntersectionHelperAdvanced.angle(prev, cur))) {
                                    intersections.add(prev.x < minX ? 6 : 2);
                                } else if (angleCorner < angleCurrent) {
                                    intersections.add(cur.y < minY ? 8 : 4);
                                } else {
                                    postfix.add(IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, cur));
                                }
                            }
                        } else if (cur.y < minY || cur.y > maxY) {
                            intersections.add(cur.y < minY ? 8 : 4);
                        }
                    }
                } else if (IntersectionHelperAdvanced.epsilionEquals(prev.x, minX) && IntersectionHelperAdvanced.epsilionEquals(cur.x, minX) || IntersectionHelperAdvanced.epsilionEquals(prev.x, maxX) && IntersectionHelperAdvanced.epsilionEquals(cur.x, maxX) || IntersectionHelperAdvanced.epsilionEquals(prev.y, minY) && IntersectionHelperAdvanced.epsilionEquals(cur.y, minY) || IntersectionHelperAdvanced.epsilionEquals(prev.y, maxY) && IntersectionHelperAdvanced.epsilionEquals(cur.y, maxY)) {
                    if (!(prev.x < minX && IntersectionHelperAdvanced.epsilionEquals(cur.x, minX) || prev.x > maxX && IntersectionHelperAdvanced.epsilionEquals(cur.x, maxX) || prev.y < minY && IntersectionHelperAdvanced.epsilionEquals(cur.y, minY) || prev.y > maxY && IntersectionHelperAdvanced.epsilionEquals(cur.y, minY))) {
                        if (!(IntersectionHelperAdvanced.epsilionEqualsSmaller(minX, prev.x) && IntersectionHelperAdvanced.epsilionEqualsSmaller(prev.x, maxX) && IntersectionHelperAdvanced.epsilionEqualsSmaller(minY, prev.y) && IntersectionHelperAdvanced.epsilionEqualsSmaller(prev.y, maxY) || prev.x < minX && IntersectionHelperAdvanced.epsilionEquals(cur.x, minX) || prev.x > maxX && IntersectionHelperAdvanced.epsilionEquals(cur.x, maxX) || prev.y < minY && IntersectionHelperAdvanced.epsilionEquals(cur.y, minY) || prev.y > maxY && IntersectionHelperAdvanced.epsilionEquals(cur.y, maxY))) {
                            postfix.add(IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, prev));
                        }
                        if (!(IntersectionHelperAdvanced.epsilionEqualsSmaller(minX, cur.x) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.x, maxX) && IntersectionHelperAdvanced.epsilionEqualsSmaller(minY, cur.y) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, maxY) || cur.x < minX && IntersectionHelperAdvanced.epsilionEquals(prev.x, minX) || cur.x > maxX && IntersectionHelperAdvanced.epsilionEquals(prev.x, maxX) || cur.y < minY && IntersectionHelperAdvanced.epsilionEquals(prev.y, minY) || cur.y > maxY && IntersectionHelperAdvanced.epsilionEquals(prev.y, maxY))) {
                            postfix.add(IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, cur));
                        }
                    }
                } else if (prev.y < minY || prev.y > maxY) {
                    if (!(prev.y < minY && IntersectionHelperAdvanced.epsilionEquals(cur.y, minY) || prev.y > maxY && IntersectionHelperAdvanced.epsilionEquals(cur.y, maxY))) {
                        intersections.add(prev.y < maxY ? 8 : 4);
                        if (cur.x < minX || cur.x > minX) {
                            if (IntersectionHelperAdvanced.epsilionEqualsSmaller(minY, cur.y) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, maxY)) {
                                intersections.add(cur.x < minX ? 2 : 6);
                            } else {
                                angleCorner = IntersectionHelperAdvanced.angle(prev, IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, cur));
                                if (angleCorner > (angleCurrent = IntersectionHelperAdvanced.angle(prev, cur))) {
                                    intersections.add(cur.x < minX ? 2 : 6);
                                } else if (angleCorner < angleCurrent) {
                                    intersections.add(prev.y < minY ? 4 : 8);
                                } else {
                                    postfix.add(IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, cur));
                                }
                            }
                        } else if (cur.y < minY || cur.y > maxY) {
                            intersections.add(cur.y < minY ? 8 : 4);
                        }
                    }
                } else if (!(cur.x < minX && IntersectionHelperAdvanced.epsilionEquals(prev.x, minX) || cur.x > maxX && IntersectionHelperAdvanced.epsilionEquals(prev.x, maxX) || cur.y < minY && IntersectionHelperAdvanced.epsilionEquals(prev.y, minY) || cur.y > maxY && IntersectionHelperAdvanced.epsilionEquals(prev.y, maxY))) {
                    if (cur.x < minX || cur.x > maxX) {
                        if (cur.y < minY || cur.y > maxY) {
                            angleCorner = IntersectionHelperAdvanced.angle(prev, IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, cur));
                            if (angleCorner > (angleCurrent = IntersectionHelperAdvanced.angle(prev, cur))) {
                                intersections.add(cur.x < minX ? 2 : 6);
                            } else if (angleCorner < angleCurrent) {
                                intersections.add(cur.y < minY ? 8 : 4);
                            } else {
                                postfix.add(IntersectionHelperAdvanced.getClosestNormalCorner(minX, minY, maxX, maxY, cur));
                            }
                        } else {
                            intersections.add(cur.x < minX ? 2 : 6);
                        }
                    } else if (cur.y < minY || cur.y > maxY) {
                        intersections.add(cur.y < minY ? 8 : 4);
                    }
                }
                block7: for (i = 0; i < intersections.size(); ++i) {
                    if (!ray.isSet()) {
                        ray.set(prev, cur);
                    }
                    switch ((Integer)intersections.get(i)) {
                        case 8: {
                            Vector2f intersection = ray.intersect(EnumFacing.Axis.Y, minY, minX, maxX);
                            if (intersection != null) {
                                if (lastIntersectingEdge != 0) {
                                    if ((cornerCount += IntersectionHelperAdvanced.getCornerCount(minX, minY, maxX, maxY, lastIntersectingEdge, 8, ray, prev, cur)) != 0 && lastIntersectingEdge != 0) {
                                        IntersectionHelperAdvanced.addNormalCorners(minX, minY, maxX, maxY, result, lastIntersectingEdge, 8, cornerCount);
                                    }
                                    cornerCount = 0;
                                    lastIntersectingEdge = 0;
                                }
                                result.add(intersection);
                                continue block7;
                            }
                            intersections.clear();
                            continue block7;
                        }
                        case 4: {
                            Vector2f intersection = ray.intersect(EnumFacing.Axis.Y, maxY, minX, maxX);
                            if (intersection != null) {
                                if (lastIntersectingEdge != 0) {
                                    if ((cornerCount += IntersectionHelperAdvanced.getCornerCount(minX, minY, maxX, maxY, lastIntersectingEdge, 4, ray, prev, cur)) != 0 && lastIntersectingEdge != 0) {
                                        IntersectionHelperAdvanced.addNormalCorners(minX, minY, maxX, maxY, result, lastIntersectingEdge, 4, cornerCount);
                                    }
                                    cornerCount = 0;
                                    lastIntersectingEdge = 0;
                                }
                                result.add(intersection);
                                continue block7;
                            }
                            intersections.clear();
                            continue block7;
                        }
                        case 2: {
                            Vector2f intersection = ray.intersect(EnumFacing.Axis.X, minX, minY, maxY);
                            if (intersection != null) {
                                if (lastIntersectingEdge != 0) {
                                    if ((cornerCount += IntersectionHelperAdvanced.getCornerCount(minX, minY, maxX, maxY, lastIntersectingEdge, 2, ray, prev, cur)) != 0 && lastIntersectingEdge != 0) {
                                        IntersectionHelperAdvanced.addNormalCorners(minX, minY, maxX, maxY, result, lastIntersectingEdge, 2, cornerCount);
                                    }
                                    cornerCount = 0;
                                    lastIntersectingEdge = 0;
                                }
                                result.add(intersection);
                                continue block7;
                            }
                            intersections.clear();
                            continue block7;
                        }
                        case 6: {
                            Vector2f intersection = ray.intersect(EnumFacing.Axis.X, maxX, minY, maxY);
                            if (intersection != null) {
                                if (lastIntersectingEdge != 0) {
                                    if ((cornerCount += IntersectionHelperAdvanced.getCornerCount(minX, minY, maxX, maxY, lastIntersectingEdge, 6, ray, prev, cur)) != 0 && lastIntersectingEdge != 0) {
                                        IntersectionHelperAdvanced.addNormalCorners(minX, minY, maxX, maxY, result, lastIntersectingEdge, 6, cornerCount);
                                    }
                                    cornerCount = 0;
                                    lastIntersectingEdge = 0;
                                }
                                result.add(intersection);
                                continue block7;
                            }
                            intersections.clear();
                        }
                    }
                }
                if (!postfix.isEmpty()) {
                    if (lastIntersectingEdge != 0) {
                        if (lastIntersectingEdge != 0 && (cornerCount += IntersectionHelperAdvanced.getCornerCount(minX, minY, maxX, maxY, lastIntersectingEdge, IntersectionHelperAdvanced.getEdgeFrom(minX, minY, maxX, maxY, !result.isEmpty() ? result.get(result.size() - 1) : (Vector2f)postfix.get(0)), ray, prev, cur)) != 0) {
                            IntersectionHelperAdvanced.addNormalCorners(minX, minY, maxX, maxY, result, lastIntersectingEdge, IntersectionHelperAdvanced.getEdgeFrom(minX, minY, maxX, maxY, (Vector2f)postfix.get(0)), cornerCount);
                        }
                        cornerCount = 0;
                        lastIntersectingEdge = 0;
                    }
                    for (i = 0; i < postfix.size(); ++i) {
                        result.add((Vector2f)postfix.get(i));
                    }
                }
                if (IntersectionHelperAdvanced.epsilionEqualsSmaller(minX, cur.x) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.x, maxX) && IntersectionHelperAdvanced.epsilionEqualsSmaller(minY, cur.y) && IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, maxY)) {
                    if (lastIntersectingEdge != 0) {
                        cornerCount = IntersectionHelperAdvanced.epsilionEquals(cur.x, minX) || IntersectionHelperAdvanced.epsilionEquals(cur.x, maxX) || IntersectionHelperAdvanced.epsilionEquals(cur.y, minY) || IntersectionHelperAdvanced.epsilionEquals(cur.y, maxY) ? (cornerCount += IntersectionHelperAdvanced.getCornerCount(minX, minY, maxX, maxY, lastIntersectingEdge, IntersectionHelperAdvanced.getEdgeFrom(minX, minY, maxX, maxY, cur), ray, prev, cur)) : (cornerCount += IntersectionHelperAdvanced.getCornerCount(minX, minY, maxX, maxY, lastIntersectingEdge, IntersectionHelperAdvanced.getEdgeFrom(minX, minY, maxX, maxY, !result.isEmpty() ? result.get(result.size() - 1) : cur), ray, prev, cur));
                        if (cornerCount != 0 && lastIntersectingEdge != 0) {
                            IntersectionHelperAdvanced.addNormalCorners(minX, minY, maxX, maxY, result, lastIntersectingEdge, IntersectionHelperAdvanced.getEdgeFrom(minX, minY, maxX, maxY, cur), cornerCount);
                        }
                        cornerCount = 0;
                        lastIntersectingEdge = 0;
                    }
                    result.add(new Vector2f(cur));
                } else {
                    if (lastIntersectingEdge == 0) {
                        lastIntersectingEdge = IntersectionHelperAdvanced.getEdgeFrom(minX, minY, maxX, maxY, !result.isEmpty() ? result.get(result.size() - 1) : prev);
                    }
                    cornerCount += IntersectionHelperAdvanced.getCornerCount(minX, minY, maxX, maxY, lastIntersectingEdge, 0, ray, prev, cur);
                    if (result.isEmpty()) {
                        firstCornerCount = cornerCount;
                    }
                }
                prev.set((Tuple2f)cur);
            }
            ci += inversed ? 0 : 1;
        }
        if (firstCornerCount + cornerCount != 0) {
            if (!result.isEmpty()) {
                if (lastIntersectingEdge != 0) {
                    IntersectionHelperAdvanced.addNormalCorners(minX, minY, maxX, maxY, result, lastIntersectingEdge, IntersectionHelperAdvanced.getEdgeFrom(minX, minY, maxX, maxY, (Vector2f)result.get(0)), firstCornerCount + cornerCount);
                }
            } else {
                result = Arrays.asList(new Vector2f(minX, minY), new Vector2f(minX, maxY), new Vector2f(maxX, maxY), new Vector2f(maxX, minY));
            }
        }
        if (inversed) {
            Collections.reverse(result);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getCornerCount(float minX, float minY, float maxX, float maxY, int lastIntersectingEdge, int currentIntersectingEdge, Ray ray, Vector2f prev, Vector2f cur) {
        if (prev.x < minX) {
            if (prev.y < minY) {
                if (cur.x > maxX) {
                    if (cur.y > maxY) {
                        if (!(ray.intersect(EnumFacing.Axis.Y, minY) < minX)) return 4;
                        return -4;
                    }
                    if (!(cur.y < minY)) return -3;
                    return -2;
                }
                if (IntersectionHelperAdvanced.epsilionEqualsGreater(cur.x, minX)) {
                    if (cur.y < minY) {
                        return -1;
                    }
                    if (cur.y > maxY) {
                        return 3;
                    }
                    if (currentIntersectingEdge == 2) {
                        return 2;
                    }
                    if (currentIntersectingEdge == 2) {
                        return 1;
                    }
                    if (currentIntersectingEdge == 1) {
                        return 0;
                    }
                    if (currentIntersectingEdge == 8) {
                        return -1;
                    }
                    if (currentIntersectingEdge != 7) return 0;
                    return -2;
                }
                if (IntersectionHelperAdvanced.epsilionEqualsGreater(cur.y, maxY)) {
                    return 2;
                }
                if (!(cur.y > minY)) return 0;
                return 1;
            }
            if (prev.y > maxY) {
                if (cur.x > maxX) {
                    if (cur.y < minY) {
                        if (!(ray.intersect(EnumFacing.Axis.Y, minY) < minX)) return 4;
                        return -4;
                    }
                    if (!(cur.y > maxY)) return 3;
                    return 2;
                }
                if (IntersectionHelperAdvanced.epsilionEqualsGreater(cur.x, minX)) {
                    if (cur.y < minY) {
                        return -3;
                    }
                    if (cur.y > maxY) {
                        return 1;
                    }
                    if (currentIntersectingEdge == 1) {
                        return -2;
                    }
                    if (currentIntersectingEdge == 2) {
                        return -1;
                    }
                    if (currentIntersectingEdge == 3) {
                        return 0;
                    }
                    if (currentIntersectingEdge == 4) {
                        return 1;
                    }
                    if (currentIntersectingEdge != 5) return 0;
                    return 2;
                }
                if (IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, minY)) {
                    return -2;
                }
                if (!(cur.y < maxY)) return 0;
                return -1;
            }
            if (cur.x > maxX) {
                if (!(cur.y < minY)) return 3;
                return -3;
            }
            if (IntersectionHelperAdvanced.epsilionEqualsGreater(cur.x, minX)) {
                if (cur.y < minY) {
                    return -2;
                }
                if (cur.y > maxY) {
                    return 2;
                }
                if (currentIntersectingEdge == 1) {
                    return -1;
                }
                if (currentIntersectingEdge == 2) {
                    return 0;
                }
                if (currentIntersectingEdge != 3) return 0;
                return 1;
            }
            if (cur.y < minY) {
                return -1;
            }
            if (!(cur.y > maxY)) return 0;
            return 1;
        }
        if (prev.x > maxX) {
            if (prev.y < minY) {
                if (cur.x < minX) {
                    if (cur.y > maxY) {
                        if (!(ray.intersect(EnumFacing.Axis.Y, minY) > maxX)) return 4;
                        return -4;
                    }
                    if (!(cur.y < minY)) return 3;
                    return 2;
                }
                if (IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.x, maxX)) {
                    if (cur.y < minY) {
                        return 1;
                    }
                    if (cur.y > maxY) {
                        return -3;
                    }
                    if (currentIntersectingEdge == 5) {
                        return -2;
                    }
                    if (currentIntersectingEdge == 6) {
                        return -1;
                    }
                    if (currentIntersectingEdge == 7) {
                        return 0;
                    }
                    if (currentIntersectingEdge == 8) {
                        return 1;
                    }
                    if (currentIntersectingEdge != 0) return 0;
                    return 2;
                }
                if (cur.y > maxY) {
                    return -2;
                }
                if (!IntersectionHelperAdvanced.epsilionEqualsGreater(cur.y, minY)) return 0;
                return -1;
            }
            if (prev.y > maxY) {
                if (cur.x < minX) {
                    if (cur.y < minY) {
                        if (!(ray.intersect(EnumFacing.Axis.Y, minY) > maxX)) return 4;
                        return -4;
                    }
                    if (!(cur.y > maxY)) return -3;
                    return -2;
                }
                if (IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.x, maxX)) {
                    if (cur.y < minY) {
                        return 3;
                    }
                    if (cur.y > maxY) {
                        return -1;
                    }
                    if (currentIntersectingEdge == 3) {
                        return -2;
                    }
                    if (currentIntersectingEdge == 4) {
                        return -1;
                    }
                    if (currentIntersectingEdge == 5) {
                        return 0;
                    }
                    if (currentIntersectingEdge == 6) {
                        return 1;
                    }
                    if (currentIntersectingEdge != 7) return 0;
                    return 2;
                }
                if (cur.y < minY) {
                    return 2;
                }
                if (!IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, maxY)) return 0;
                return 1;
            }
            if (cur.x < minX) {
                if (cur.y < minY) {
                    return 3;
                }
                if (!(cur.y > maxY)) return 0;
                return -3;
            }
            if (IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.x, maxX)) {
                if (cur.y < minY) {
                    return 2;
                }
                if (cur.y > maxY) {
                    return -2;
                }
                if (currentIntersectingEdge == 5) {
                    return -1;
                }
                if (currentIntersectingEdge == 7) {
                    return 1;
                }
                if (currentIntersectingEdge != 6) return 0;
                return 0;
            }
            if (cur.y > maxY) {
                return -1;
            }
            if (!(cur.y < minY)) return 0;
            return 1;
        }
        if (prev.y < minY) {
            if (cur.x < minX) {
                if (cur.y < minY) {
                    return 1;
                }
                if (!(cur.y > maxY)) return 2;
                return 3;
            }
            if (cur.x > maxX) {
                if (cur.y < minY) {
                    return -1;
                }
                if (!(cur.y > maxY)) return -2;
                return -3;
            }
            if (currentIntersectingEdge == 7) {
                return -1;
            }
            if (currentIntersectingEdge == 8) {
                return 0;
            }
            if (currentIntersectingEdge != 1) return 0;
            return 1;
        }
        if (prev.y > maxY) {
            if (cur.x < minX) {
                if (cur.y < minY) {
                    return -3;
                }
                if (!(cur.y > maxY)) return -2;
                return -1;
            }
            if (cur.x > maxX) {
                if (cur.y < minY) {
                    return 3;
                }
                if (!(cur.y > maxY)) return 2;
                return 1;
            }
            if (currentIntersectingEdge == 3) {
                return -1;
            }
            if (currentIntersectingEdge == 4) {
                return 0;
            }
            if (currentIntersectingEdge != 5) return 0;
            return 1;
        }
        switch (lastIntersectingEdge) {
            case 0: {
                return 0;
            }
            case 7: {
                if (cur.x < minX) {
                    return 2;
                }
                if (IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.x, maxX)) {
                    return 1;
                }
                if (cur.y > maxY) {
                    return -2;
                }
                if (!IntersectionHelperAdvanced.epsilionEqualsGreater(cur.y, minY)) return 0;
                return -1;
            }
            case 8: {
                if (cur.x < minX) {
                    return 1;
                }
                if (!(cur.x > maxX)) return 0;
                return -1;
            }
            case 3: {
                if (cur.x > maxX) {
                    return 2;
                }
                if (IntersectionHelperAdvanced.epsilionEqualsGreater(cur.x, minX)) {
                    return 1;
                }
                if (cur.y < minY) {
                    return -2;
                }
                if (!IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, maxY)) return 0;
                return -1;
            }
            case 4: {
                if (cur.x < minX) {
                    return -1;
                }
                if (!(cur.x > maxX)) return 0;
                return 1;
            }
            case 1: {
                if (cur.y > maxY) {
                    return 2;
                }
                if (IntersectionHelperAdvanced.epsilionEqualsGreater(cur.y, minY)) {
                    return 1;
                }
                if (cur.x > maxX) {
                    return -2;
                }
                if (!IntersectionHelperAdvanced.epsilionEqualsGreater(cur.x, minX)) return 0;
                return -1;
            }
            case 2: {
                if (cur.y < minY) {
                    return -1;
                }
                if (!(cur.y > maxY)) return 0;
                return 1;
            }
            case 5: {
                if (cur.y < minY) {
                    return 2;
                }
                if (IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.y, maxY)) {
                    return 1;
                }
                if (cur.x < minX) {
                    return -2;
                }
                if (!IntersectionHelperAdvanced.epsilionEqualsSmaller(cur.x, maxX)) return 0;
                return -1;
            }
            case 6: {
                if (cur.y < minY) {
                    return 1;
                }
                if (!(cur.y > maxY)) return 0;
                return -1;
            }
        }
        return 0;
    }

    public static Vector2f getCorner(float minX, float minY, float maxX, float maxY, int index) {
        switch (index) {
            case 0: {
                return new Vector2f(minX, minY);
            }
            case 1: {
                return new Vector2f(minX, maxY);
            }
            case 2: {
                return new Vector2f(maxX, maxY);
            }
            case 3: {
                return new Vector2f(maxX, minY);
            }
        }
        return null;
    }

    public static void addNormalCorners(float minX, float minY, float maxX, float maxY, List<Vector2f> result, int lastIntersectingEdge, int currentIntersectingEdge, int cornerCount) {
        block11: {
            block10: {
                if (cornerCount <= 0) break block10;
                if (lastIntersectingEdge % 2 == 1) {
                    if (currentIntersectingEdge - lastIntersectingEdge == 2) {
                        return;
                    }
                    ++lastIntersectingEdge;
                }
                if (currentIntersectingEdge % 2 == 1) {
                    --currentIntersectingEdge;
                }
                if (currentIntersectingEdge < lastIntersectingEdge) {
                    currentIntersectingEdge += 8;
                }
                for (int i = lastIntersectingEdge; i < currentIntersectingEdge; i += 2) {
                    result.add(IntersectionHelperAdvanced.getCorner(minX, minY, maxX, maxY, (int)(Math.floor(i / 2) % 4.0)));
                }
                break block11;
            }
            if (cornerCount >= 0) break block11;
            if (lastIntersectingEdge % 2 == 1) {
                if (currentIntersectingEdge - lastIntersectingEdge == -2) {
                    return;
                }
                --lastIntersectingEdge;
            }
            if (currentIntersectingEdge % 2 == 1) {
                ++currentIntersectingEdge;
            }
            if (lastIntersectingEdge < currentIntersectingEdge) {
                lastIntersectingEdge += 8;
            }
            int i = lastIntersectingEdge;
            while ((i -= 2) > currentIntersectingEdge) {
                result.add(IntersectionHelperAdvanced.getCorner(minX, minY, maxX, maxY, (int)(Math.floor(i / 2) % 4.0)));
            }
        }
    }

    public static boolean epsilionEquals(float value, float toCheck) {
        return (value -= toCheck) > -1.0E-5f && value < 1.0E-5f;
    }

    public static boolean epsilionGreater(float value, float toCheck) {
        return value > toCheck && !IntersectionHelperAdvanced.epsilionEquals(value, toCheck);
    }

    public static boolean epsilionSmaller(float value, float toCheck) {
        return value < toCheck && !IntersectionHelperAdvanced.epsilionEquals(value, toCheck);
    }

    public static boolean epsilionEqualsGreater(float value, float toCheck) {
        return value > toCheck || IntersectionHelperAdvanced.epsilionEquals(value, toCheck);
    }

    public static boolean epsilionEqualsSmaller(float value, float toCheck) {
        return value < toCheck || IntersectionHelperAdvanced.epsilionEquals(value, toCheck);
    }

    public static int getEdgeFrom(float minX, float minY, float maxX, float maxY, Vector2f vec) {
        if (IntersectionHelperAdvanced.epsilionEquals(vec.x, minX)) {
            if (IntersectionHelperAdvanced.epsilionEquals(vec.y, minY)) {
                return 1;
            }
            if (IntersectionHelperAdvanced.epsilionEquals(vec.y, maxY)) {
                return 3;
            }
            return 2;
        }
        if (IntersectionHelperAdvanced.epsilionEquals(vec.x, maxX)) {
            if (IntersectionHelperAdvanced.epsilionEquals(vec.y, minY)) {
                return 7;
            }
            if (IntersectionHelperAdvanced.epsilionEquals(vec.y, maxY)) {
                return 5;
            }
            return 6;
        }
        if (IntersectionHelperAdvanced.epsilionEquals(vec.y, minY)) {
            if (IntersectionHelperAdvanced.epsilionEquals(vec.x, minX)) {
                return 9;
            }
            if (IntersectionHelperAdvanced.epsilionEquals(vec.x, maxX)) {
                return 7;
            }
            return 8;
        }
        if (IntersectionHelperAdvanced.epsilionEquals(vec.y, maxY)) {
            if (IntersectionHelperAdvanced.epsilionEquals(vec.x, minX)) {
                return 3;
            }
            if (IntersectionHelperAdvanced.epsilionEquals(vec.x, maxX)) {
                return 5;
            }
            return 4;
        }
        return 0;
    }

    public static int getNonantsEdgeFrom(float minX, float minY, float maxX, float maxY, Vector2f vec) {
        if (IntersectionHelperAdvanced.epsilionEqualsSmaller(vec.x, minX)) {
            if (IntersectionHelperAdvanced.epsilionEqualsSmaller(vec.y, minY)) {
                return 1;
            }
            if (IntersectionHelperAdvanced.epsilionEqualsGreater(vec.y, maxY)) {
                return 3;
            }
            return 2;
        }
        if (IntersectionHelperAdvanced.epsilionEqualsGreater(vec.x, maxX)) {
            if (IntersectionHelperAdvanced.epsilionEqualsSmaller(vec.y, minY)) {
                return 7;
            }
            if (IntersectionHelperAdvanced.epsilionEqualsGreater(vec.y, maxY)) {
                return 5;
            }
            return 6;
        }
        if (IntersectionHelperAdvanced.epsilionEqualsSmaller(vec.y, minY)) {
            if (IntersectionHelperAdvanced.epsilionEqualsSmaller(vec.x, minX)) {
                return 9;
            }
            if (IntersectionHelperAdvanced.epsilionEqualsGreater(vec.x, maxX)) {
                return 7;
            }
            return 8;
        }
        if (IntersectionHelperAdvanced.epsilionEqualsGreater(vec.y, maxY)) {
            if (IntersectionHelperAdvanced.epsilionEqualsSmaller(vec.x, minX)) {
                return 3;
            }
            if (IntersectionHelperAdvanced.epsilionEqualsGreater(vec.x, maxX)) {
                return 5;
            }
            return 4;
        }
        return 0;
    }

    public static Vector2f getClosestNormalCorner(float minX, float minY, float maxX, float maxY, Vector2f vec) {
        if (vec.x < (minX + maxX) / 2.0f) {
            if (vec.y < (minY + maxY) / 2.0f) {
                return new Vector2f(minX, minY);
            }
            return new Vector2f(minX, maxY);
        }
        if (vec.y < (minY + maxY) / 2.0f) {
            return new Vector2f(maxX, minY);
        }
        return new Vector2f(maxX, maxY);
    }

    public static Vector2f getOpositeClosestNormalCorner(float minX, float minY, float maxX, float maxY, Vector2f vec) {
        if (vec.x < (minX + maxX) / 2.0f) {
            if (vec.y < (minY + maxY) / 2.0f) {
                return new Vector2f(maxX, maxY);
            }
            return new Vector2f(maxX, minY);
        }
        if (vec.y < (minY + maxY) / 2.0f) {
            return new Vector2f(minX, maxY);
        }
        return new Vector2f(minX, minY);
    }

    public static boolean isBetween(float min, float max, float vec) {
        return IntersectionHelperAdvanced.epsilionEqualsSmaller(min, vec) && IntersectionHelperAdvanced.epsilionEqualsSmaller(vec, max);
    }

    public static float angle(Vector2f v) {
        if (v.x == 0.0f) {
            return 0.0f;
        }
        if (v.y == 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        return Math.abs(v.y) / Math.abs(v.x);
    }

    public static float angle(Vector2f from, Vector2f to) {
        if (from.x == to.x) {
            return 0.0f;
        }
        if (from.y == to.y) {
            return Float.POSITIVE_INFINITY;
        }
        return Math.abs(to.y - from.y) / Math.abs(to.x - from.x);
    }

    private static class Ray {
        public Vector2f origin = new Vector2f();
        public Vector2f direction = new Vector2f();
        private boolean set = false;

        private Ray() {
        }

        public void reset() {
            this.set = false;
        }

        public boolean isSet() {
            return this.set;
        }

        public void set(Vector2f a, Vector2f b) {
            this.origin.set((Tuple2f)a);
            this.direction.set((Tuple2f)b);
            this.direction.sub((Tuple2f)a);
            this.direction.normalize();
            this.set = true;
        }

        public float intersect(EnumFacing.Axis axis, float value) {
            if (axis == EnumFacing.Axis.X) {
                if (this.direction.x == 0.0f) {
                    return Float.NaN;
                }
                return this.origin.y + this.direction.y * (value - this.origin.x) / this.direction.x;
            }
            if (this.direction.y == 0.0f) {
                return Float.NaN;
            }
            return this.origin.x + this.direction.x * (value - this.origin.y) / this.direction.y;
        }

        public Vector2f intersect(EnumFacing.Axis axis, float value, double min, double max) {
            if (axis == EnumFacing.Axis.X) {
                if (this.direction.x == 0.0f) {
                    return null;
                }
                float result = this.origin.y + this.direction.y * (value - this.origin.x) / this.direction.x;
                if ((double)result > min && (double)result < max) {
                    return new Vector2f(value, result);
                }
                return null;
            }
            if (this.direction.y == 0.0f) {
                return null;
            }
            float result = this.origin.x + this.direction.x * (value - this.origin.y) / this.direction.y;
            if ((double)result > min && (double)result < max) {
                return new Vector2f(result, value);
            }
            return null;
        }
    }
}

