/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui;

import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import net.minecraft.util.math.MathHelper;

public class GuiCounter
extends GuiParent {
    public int min;
    public int max;
    public GuiTextfield textfield;

    public GuiCounter(String name, int x, int y, int width, int value, int min, int max) {
        super(name, x, y, width, 10);
        this.min = min;
        this.max = max;
        this.marginWidth = 0;
        this.setStyle(Style.emptyStyle);
        this.textfield = new GuiTextfield("value", "" + MathHelper.func_76125_a((int)value, (int)min, (int)max), 0, 0, width - 11, 8).setNumbersOnly();
        this.addControl(this.textfield.setStyle(defaultStyle));
        this.addControl(new GuiButton("-", "-", width - 6, 7, 4, 1){

            @Override
            public void onClicked(int x, int y, int button) {
                GuiCounter.this.textfield.text = "" + GuiCounter.this.stepDown(GuiCounter.this.textfield.parseInteger());
                this.raiseEvent(new GuiControlChangedEvent(GuiCounter.this));
            }
        }.setStyle(defaultStyle));
        this.addControl(new GuiButton("+", "+", width - 6, 0, 4, 2){

            @Override
            public void onClicked(int x, int y, int button) {
                GuiCounter.this.textfield.text = "" + GuiCounter.this.stepUp(GuiCounter.this.textfield.parseInteger());
                this.raiseEvent(new GuiControlChangedEvent(GuiCounter.this));
            }
        }.setStyle(defaultStyle));
    }

    @Override
    public boolean raiseEvent(ControlEvent event) {
        if (event instanceof GuiControlChangedEvent && event.source.is("value")) {
            return super.raiseEvent(new GuiControlChangedEvent(this));
        }
        return super.raiseEvent(event);
    }

    public int stepUp(int value) {
        return Math.min(this.max, value + 1);
    }

    public int stepDown(int value) {
        return Math.max(this.min, value - 1);
    }

    public int getValue() {
        return MathHelper.func_76125_a((int)this.textfield.parseInteger(), (int)this.min, (int)this.max);
    }

    public void setValue(int value) {
        this.textfield.text = "" + MathHelper.func_76125_a((int)value, (int)this.min, (int)this.max);
    }
}

