/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.config.gui;

import com.creativemd.creativecore.common.config.holder.ConfigKey;
import com.creativemd.creativecore.common.config.holder.ICreativeConfigHolder;
import com.creativemd.creativecore.common.config.sync.ConfigurationClientPacket;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.type.CheckTree;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;

public class SubGuiClientSync
extends SubGui {
    public final CheckTree<ConfigKey> tree;
    public final ICreativeConfigHolder root;
    public CheckTree.CheckTreeEntry currentView;
    public boolean changed = false;
    public int nextAction;
    public boolean force;

    public SubGuiClientSync(ICreativeConfigHolder holder) {
        super(200, 200);
        this.root = holder;
        BiConsumer<ConfigKey, Boolean> setter = (x, y) -> {
            x.forceSynchronization = y;
        };
        Function<ConfigKey, Boolean> getter = x -> x.forceSynchronization;
        Function<ConfigKey, Collection> getChildren = x -> {
            if (x.getDefault() instanceof ICreativeConfigHolder) {
                ArrayList<ConfigKey> keys = new ArrayList<ConfigKey>();
                for (ConfigKey configKey : ((ICreativeConfigHolder)x.getDefault()).fields()) {
                    Object object;
                    if (!configKey.isWithoutForce(Side.CLIENT) || (object = configKey.get()) instanceof ICreativeConfigHolder && ((ICreativeConfigHolder)object).isEmptyWithoutForce(Side.CLIENT)) continue;
                    keys.add(configKey);
                }
                return keys;
            }
            return null;
        };
        ArrayList<ConfigKey> keys = new ArrayList<ConfigKey>();
        for (ConfigKey configKey : holder.fields()) {
            Object object;
            if (!configKey.isWithoutForce(Side.CLIENT) || (object = configKey.get()) instanceof ICreativeConfigHolder && ((ICreativeConfigHolder)object).isEmptyWithoutForce(Side.CLIENT)) continue;
            keys.add(configKey);
        }
        this.tree = new CheckTree<ConfigKey>(keys, setter, getter, getChildren);
        this.currentView = this.tree.root;
    }

    @Override
    public void createControls() {
        this.load(this.currentView);
    }

    public void save() {
        PacketHandler.sendPacketToServer(new ConfigurationClientPacket(this.root, this.tree));
    }

    public void load(final CheckTree.CheckTreeEntry entry) {
        if (!this.controls.isEmpty()) {
            this.controls.clear();
        }
        ICreativeConfigHolder holder = entry.content == null ? this.root : (ICreativeConfigHolder)((ConfigKey)entry.content).get();
        this.controls.add(new GuiLabel("/" + String.join((CharSequence)"/", holder.path()), 0, 0));
        if (entry.parent != null) {
            this.controls.add(new GuiButton("back", 170, 0){

                @Override
                public void onClicked(int x, int y, int button) {
                    SubGuiClientSync.this.load(entry.parent);
                }
            });
        }
        this.currentView = entry;
        GuiScrollBox box = new GuiScrollBox("box", 0, 21, 194, 152);
        this.controls.add(box);
        int offsetX = 20;
        int offsetY = 1;
        for (final CheckTree.CheckTreeEntry key : this.currentView.children) {
            box.addControl(new GuiTreeCheckBox(key, 2, offsetY + 3));
            String caption = SubGuiClientSync.translateOrDefault("config." + String.join((CharSequence)".", holder.path() + "." + ((ConfigKey)key.content).name + ".name"), ((ConfigKey)key.content).name);
            String comment = "config." + String.join((CharSequence)".", holder.path()) + "." + ((ConfigKey)key.content).name + ".comment";
            if (key.content != null && ((ConfigKey)key.content).get() instanceof ICreativeConfigHolder) {
                box.addControl(new GuiButton(caption, offsetX, offsetY){

                    @Override
                    public void onClicked(int x, int y, int button) {
                        SubGuiClientSync.this.load(key);
                    }
                }.setLangTooltip(comment));
                offsetY += 21;
                continue;
            }
            GuiLabel label = new GuiLabel(caption, offsetX, offsetY + 2);
            box.addControl(label.setLangTooltip(comment));
            offsetY += label.height + 1;
        }
        this.controls.add(new GuiButton("cancel", 0, 180){

            @Override
            public void onClicked(int x, int y, int button) {
                SubGuiClientSync.this.nextAction = 0;
                SubGuiClientSync.this.closeGui();
            }
        });
        this.controls.add(new GuiButton("config", 40, 180){

            @Override
            public void onClicked(int x, int y, int button) {
                SubGuiClientSync.this.nextAction = 1;
                SubGuiClientSync.this.closeGui();
            }
        });
        this.controls.add(new GuiButton("save", 170, 180){

            @Override
            public void onClicked(int x, int y, int button) {
                SubGuiClientSync.this.nextAction = 0;
                SubGuiClientSync.this.force = true;
                SubGuiClientSync.this.save();
                SubGuiClientSync.this.closeGui();
            }
        });
        this.refreshControls();
    }

    @Override
    public void onDialogClosed(String text, String[] buttons, String clicked) {
        if (clicked.equals("Yes")) {
            this.save();
        }
        if (!clicked.equals("Cancel")) {
            this.force = true;
            this.closeGui();
        }
    }

    @Override
    public void closeGui() {
        if (this.force || !this.changed) {
            if (this.nextAction == 0) {
                super.closeGui();
            } else if (this.nextAction == 1) {
                GuiHandler.openGui("config", new NBTTagCompound());
            }
        } else {
            this.openButtonDialogDialog("Do you want to save your changes?", "Yes", "No", "Cancel");
        }
    }

    @CustomEventSubscribe
    public void changed(GuiControlChangedEvent event) {
        this.changed = true;
        if (event.source instanceof GuiTreeCheckBox && !((GuiTreeCheckBox)event.source).value) {
            ((GuiTreeCheckBox)event.source).partial = ((GuiTreeCheckBox)event.source).entry.isChildEnabled();
        }
    }

    public static class GuiTreeCheckBox
    extends GuiCheckBox {
        public final CheckTree.CheckTreeEntry entry;

        public GuiTreeCheckBox(CheckTree.CheckTreeEntry entry, int x, int y) {
            super(((ConfigKey)entry.content).name, "", x, y, entry.isEnabled());
            this.entry = entry;
            if (!this.value) {
                this.partial = entry.isChildEnabled();
            }
        }

        @Override
        public boolean mousePressed(int posX, int posY, int button) {
            GuiTreeCheckBox.playSound(SoundEvents.field_187909_gi);
            boolean bl = this.value = !this.value;
            if (this.value) {
                this.entry.enable();
            } else {
                this.entry.disable();
            }
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
    }
}

