/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.clientnotif;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.malisis.core.MalisisCore;
import net.malisis.core.util.WeakNested;
import net.malisis.core.util.clientnotif.ClientNotification;
import net.malisis.core.util.clientnotif.NeighborChangedMessage;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.tuple.Triple;

public class ClientNotificationManager {
    private static Set<Block> clientBlocks = Sets.newHashSet();
    private static WeakNested.List<Chunk, Triple<BlockPos, Block, BlockPos>> updatedPos = new WeakNested.List(ArrayList::new);

    private static void registerBlockNotif(Block block) {
        clientBlocks.add(block);
    }

    private static boolean needsNotification(Block block) {
        return clientBlocks.contains(block);
    }

    public static void discover(Block block) {
        try {
            Class<?> clazz = block.getClass();
            Method m = clazz.getMethod(MalisisCore.isObfEnv ? "func_189540_a" : "neighborChanged", IBlockState.class, World.class, BlockPos.class, Block.class, BlockPos.class);
            ClientNotification anno = m.getAnnotation(ClientNotification.class);
            if (anno != null) {
                ClientNotificationManager.registerBlockNotif(block);
            }
        }
        catch (ReflectiveOperationException e) {
            MalisisCore.log.error("Failed to find @ClientNotification annotation for {} : ", (Object)block, (Object)e);
        }
    }

    public static void notify(World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!ClientNotificationManager.needsNotification(state.func_177230_c())) {
            return;
        }
        updatedPos.add((Object)world.func_175726_f(pos), Triple.of((Object)pos, (Object)neighborBlock, (Object)neighborPos));
    }

    public static void sendNeighborNotification(World world) {
        for (Chunk chunk : updatedPos.keys()) {
            NeighborChangedMessage.send(chunk, (List<Triple<BlockPos, Block, BlockPos>>)updatedPos.get((Object)chunk));
        }
        updatedPos.clear();
    }
}

