/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.blockdata;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.util.Silenced;
import net.malisis.core.util.Utils;
import net.malisis.core.util.blockdata.BlockDataMessage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@AutoLoad
public class BlockDataHandler {
    private static BlockDataHandler instance = new BlockDataHandler();
    private static Field chunkCacheField;
    private static Class<?> chunkCacheClass;
    private Map<String, HandlerInfo<?>> handlerInfos = new HashMap();
    private static final ThreadLocal<Table<String, Chunk, ChunkData<?>>> datas;

    private BlockDataHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Map<String, HandlerInfo<?>> getHandlerInfos() {
        return this.handlerInfos;
    }

    private World world(IBlockAccess world) {
        if (world instanceof World) {
            return (World)world;
        }
        if (world instanceof ChunkCache) {
            return ((ChunkCache)world).field_72815_e;
        }
        if (!FMLClientHandler.instance().hasOptifine()) {
            return null;
        }
        if (chunkCacheClass == null || chunkCacheField != null) {
            return null;
        }
        if (!chunkCacheClass.isAssignableFrom(world.getClass())) {
            return null;
        }
        return this.world((IBlockAccess)Silenced.get(() -> (ChunkCache)chunkCacheField.get(world)));
    }

    private <T> ChunkData<T> chunkData(String identifier, World world, BlockPos pos) {
        return world != null ? this.chunkData(identifier, world, world.func_175726_f(pos)) : null;
    }

    private <T> ChunkData<T> chunkData(String identifier, World world, Chunk chunk) {
        Table<String, Chunk, ChunkData<?>> data = datas.get();
        return (ChunkData)data.get((Object)identifier, (Object)chunk);
    }

    private <T> ChunkData<T> createChunkData(String identifier, World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        ChunkData chunkData = new ChunkData(this.handlerInfos.get(identifier));
        datas.get().put((Object)identifier, (Object)chunk, chunkData);
        return chunkData;
    }

    @SubscribeEvent
    public void onDataLoad(ChunkDataEvent.Load event) {
        NBTTagCompound nbt = event.getData();
        for (HandlerInfo<?> handlerInfo : this.handlerInfos.values()) {
            if (!nbt.func_74764_b(handlerInfo.identifier)) continue;
            ChunkData chunkData = new ChunkData(handlerInfo);
            chunkData.fromBytes(Unpooled.copiedBuffer((byte[])nbt.func_74770_j(handlerInfo.identifier)));
            datas.get().put((Object)handlerInfo.identifier, (Object)event.getChunk(), chunkData);
        }
    }

    @SubscribeEvent
    public void onDataSave(ChunkDataEvent.Save event) {
        NBTTagCompound nbt = event.getData();
        for (HandlerInfo<?> handlerInfo : this.handlerInfos.values()) {
            ChunkData chunkData = this.chunkData(handlerInfo.identifier, event.getWorld(), event.getChunk());
            if (chunkData != null && chunkData.hasData()) {
                ByteBuf buf = Unpooled.buffer();
                chunkData.toBytes(buf);
                nbt.func_74773_a(handlerInfo.identifier, buf.capacity(buf.writerIndex()).array());
            }
            if (!event.getChunk().field_189550_d) continue;
            datas.get().remove((Object)handlerInfo.identifier, (Object)event.getChunk());
        }
    }

    @SubscribeEvent
    public void onDataUnload(ChunkEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        for (HandlerInfo<?> handlerInfo : this.handlerInfos.values()) {
            datas.get().remove((Object)handlerInfo.identifier, (Object)event.getChunk());
        }
    }

    @SubscribeEvent
    public void onChunkWatched(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.getPlayer().field_70170_p.func_72964_e(event.getChunk().field_77276_a, event.getChunk().field_77275_b);
        for (HandlerInfo<?> handlerInfo : this.handlerInfos.values()) {
            ChunkData chunkData = instance.chunkData(handlerInfo.identifier, chunk.func_177412_p(), chunk);
            if (chunkData == null || !chunkData.hasData()) continue;
            BlockDataMessage.sendBlockData(chunk, handlerInfo.identifier, chunkData.toBytes(Unpooled.buffer()), event.getPlayer());
        }
    }

    public static <T> void registerBlockData(String identifier, Function<ByteBuf, T> fromBytes, Function<T, ByteBuf> toBytes) {
        BlockDataHandler.instance.handlerInfos.put(identifier, new HandlerInfo<T>(identifier, fromBytes, toBytes));
    }

    public static <T> T getData(String identifier, IBlockAccess world, BlockPos pos) {
        ChunkData<T> chunkData = instance.chunkData(identifier, instance.world(world), pos);
        return chunkData != null ? (T)chunkData.getData(pos) : null;
    }

    public static <T> void setData(String identifier, IBlockAccess world, BlockPos pos, T data) {
        BlockDataHandler.setData(identifier, world, pos, data, false);
    }

    public static <T> void setData(String identifier, IBlockAccess world, BlockPos pos, T data, boolean sendToClients) {
        World w = instance.world(world);
        ChunkData<T> chunkData = instance.chunkData(identifier, w, pos);
        if (chunkData == null) {
            chunkData = instance.createChunkData(identifier, instance.world(world), pos);
        }
        chunkData.setData(pos, data);
        if (sendToClients && !w.field_72995_K) {
            ByteBuf buf = chunkData.toBytes(Unpooled.buffer());
            Utils.getLoadedChunk(w, pos).ifPresent(chunk -> BlockDataMessage.sendBlockData(chunk, identifier, buf));
        }
    }

    public static <T> void removeData(String identifier, IBlockAccess world, BlockPos pos) {
        BlockDataHandler.removeData(identifier, world, pos, false);
    }

    public static <T> void removeData(String identifier, IBlockAccess world, BlockPos pos, boolean sendToClients) {
        BlockDataHandler.setData(identifier, world, pos, null, sendToClients);
    }

    static void setBlockData(int chunkX, int chunkZ, String identifier, ByteBuf data) {
        HandlerInfo<?> handlerInfo = BlockDataHandler.instance.handlerInfos.get(identifier);
        if (handlerInfo == null) {
            return;
        }
        Chunk chunk = Utils.getClientWorld().func_72964_e(chunkX, chunkZ);
        ChunkData<?> chunkData = new ChunkData(handlerInfo).fromBytes(data);
        datas.get().put((Object)handlerInfo.identifier, (Object)chunk, chunkData);
    }

    public static BlockDataHandler get() {
        return instance;
    }

    static {
        if (MalisisCore.isClient() && FMLClientHandler.instance().hasOptifine() && (chunkCacheClass = Silenced.get(() -> Class.forName("ChunkCacheOF"))) != null) {
            chunkCacheField = AsmUtils.changeFieldAccess(chunkCacheClass, "chunkCache");
        }
        datas = ThreadLocal.withInitial(HashBasedTable::create);
    }

    static class ChunkData<T> {
        private HandlerInfo<T> handlerInfos;
        private HashMap<BlockPos, T> data = new HashMap();

        public ChunkData(HandlerInfo<T> handlerInfo) {
            this.handlerInfos = handlerInfo;
        }

        public boolean hasData() {
            return this.data.size() > 0;
        }

        public T getData(BlockPos pos) {
            return this.data.get(pos);
        }

        public void setData(BlockPos pos, T blockData) {
            if (blockData != null) {
                this.data.put(pos, blockData);
            } else {
                this.data.remove(pos);
            }
        }

        public ChunkData<T> fromBytes(ByteBuf buf) {
            while (buf.isReadable()) {
                BlockPos pos = BlockPos.func_177969_a((long)buf.readLong());
                ByteBuf b = buf.readBytes(buf.readInt());
                Object blockData = ((HandlerInfo)this.handlerInfos).fromBytes.apply((Object)b);
                this.data.put(pos, blockData);
            }
            return this;
        }

        public ByteBuf toBytes(ByteBuf buf) {
            for (Map.Entry<BlockPos, T> entry : this.data.entrySet()) {
                ByteBuf b = (ByteBuf)((HandlerInfo)this.handlerInfos).toBytes.apply(entry.getValue());
                buf.writeLong(entry.getKey().func_177986_g());
                buf.writeInt(b.writerIndex());
                buf.writeBytes(b);
            }
            return buf;
        }
    }

    public static class HandlerInfo<T> {
        String identifier;
        private Function<ByteBuf, T> fromBytes;
        private Function<T, ByteBuf> toBytes;

        public HandlerInfo(String identifier, Function<ByteBuf, T> fromBytes, Function<T, ByteBuf> toBytes) {
            this.identifier = identifier;
            this.fromBytes = fromBytes;
            this.toBytes = toBytes;
        }
    }
}

