/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

public class MathUtil {
    public static int scalei(int originalValue, int originalMin, int originalMax, int newMin, int newMax) {
        int originalRange = originalMax - originalMin;
        if (originalRange == 0) {
            return newMin;
        }
        int newRange = newMax - newMin;
        return (originalValue - originalMin) * newRange / originalRange + newMin;
    }

    public static float scalef(float originalValue, float originalMin, float originalMax, float newMin, float newMax) {
        float originalRange = originalMax - originalMin;
        if (originalRange == 0.0f) {
            return newMin;
        }
        float newRange = newMax - newMin;
        return (originalValue - originalMin) * newRange / originalRange + newMin;
    }

    public static double scaled(double originalValue, double originalMin, double originalMax, double newMin, double newMax) {
        double originalRange = originalMax - originalMin;
        if (originalRange == 0.0) {
            return newMin;
        }
        double newRange = newMax - newMin;
        return (originalValue - originalMin) * newRange / originalRange + newMin;
    }

    public static int squashi(int value, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum value [" + min + "] cannot be greater than the maximum value [" + max + "]!");
        }
        if (max < min) {
            throw new IllegalArgumentException("Maximum value [" + max + "] cannot be lesser than the minimum value [" + min + "]!");
        }
        return Math.min(Math.max(value, min), max);
    }

    public static float squashf(float value, float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum value [" + min + "] cannot be greater than the maximum value [" + max + "]!");
        }
        if (max < min) {
            throw new IllegalArgumentException("Maximum value [" + max + "] cannot be lesser than the minimum value [" + min + "]!");
        }
        return Math.min(Math.max(value, min), max);
    }

    public static double squashd(double value, double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum value [" + min + "] cannot be greater than the maximum value [" + max + "]!");
        }
        if (max < min) {
            throw new IllegalArgumentException("Maximum value [" + max + "] cannot be lesser than the minimum value [" + min + "]!");
        }
        return Math.min(Math.max(value, min), max);
    }

    public static boolean withinRange(double value, double start, double end) {
        return value >= start && value <= end;
    }
}

