/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;

public class BrightnessTransform
extends Transformation<BrightnessTransform, ITransformable.Brightness> {
    protected int fromBrightness;
    protected int toBrightness;

    public BrightnessTransform(int fromBrightness, int toBrightness) {
        this.fromBrightness = fromBrightness;
        this.toBrightness = toBrightness;
    }

    @Override
    public BrightnessTransform self() {
        return this;
    }

    public BrightnessTransform from(int brightness) {
        this.fromBrightness = brightness;
        return this;
    }

    public BrightnessTransform to(int brightness) {
        this.toBrightness = brightness;
        return this;
    }

    @Override
    protected void doTransform(ITransformable.Brightness transformable, float comp) {
        if (comp <= 0.0f) {
            return;
        }
        float from = this.reversed ? (float)this.toBrightness : (float)this.fromBrightness;
        float to = this.reversed ? (float)this.fromBrightness : (float)this.toBrightness;
        transformable.setBrightness((int)(from + (to - from) * comp));
    }
}

