/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.registry.ClientRegistry;
import net.malisis.core.registry.ModEventRegistry;
import net.malisis.core.registry.Registries;
import net.malisis.core.registry.RenderBlockRegistry;
import net.malisis.core.registry.SetBlockCallbackRegistry;
import net.malisis.core.registry.TextureStitchedRegistry;
import net.malisis.core.renderer.IBlockRenderer;
import net.malisis.core.renderer.IItemRenderer;
import net.malisis.core.renderer.IRenderWorldLast;
import net.malisis.core.renderer.model.EmptyModelLoader;
import net.malisis.core.util.callback.ICallback;
import net.malisis.core.util.clientnotif.ClientNotificationManager;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MalisisRegistry {
    public static void onPreInit(ModEventRegistry.IFMLEventCallback<FMLPreInitializationEvent> callback) {
        Registries.modEventRegistry.registerCallback(FMLPreInitializationEvent.class, callback);
    }

    public static void onInit(ModEventRegistry.IFMLEventCallback<FMLInitializationEvent> callback) {
        Registries.modEventRegistry.registerCallback(FMLInitializationEvent.class, callback);
    }

    public static void onPostInit(ModEventRegistry.IFMLEventCallback<FMLPostInitializationEvent> callback) {
        Registries.modEventRegistry.registerCallback(FMLPostInitializationEvent.class, callback);
    }

    public static void onLoadComplete(ModEventRegistry.IFMLEventCallback<FMLLoadCompleteEvent> callback) {
        Registries.modEventRegistry.registerCallback(FMLLoadCompleteEvent.class, callback);
    }

    public static void register(IRegisterable<?> registerable) {
        ResourceLocation name = registerable.getName();
        if (name == null) {
            throw new IllegalArgumentException("No name specified for registration for " + registerable.getClass().getName());
        }
        if (!(registerable instanceof Block) && !(registerable instanceof Item)) {
            throw new IllegalArgumentException("Cannot register " + registerable.getClass().getName() + " (" + name + ") because it's neither a block or an item.");
        }
        if (registerable instanceof Block) {
            Block block = (Block)registerable;
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            Item item = registerable.getItem(block);
            if (item != null) {
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            }
            if (MalisisCore.isClient()) {
                ModelLoader.setCustomStateMapper((Block)block, b -> ImmutableMap.of());
                if (item != null) {
                    EmptyModelLoader.register(item);
                }
            }
            ClientNotificationManager.discover(block);
        } else if (registerable instanceof Item) {
            Item item = (Item)registerable;
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            if (MalisisCore.isClient()) {
                EmptyModelLoader.register(item);
            }
        }
    }

    public static void onTextureStitched(TextureStitchedRegistry.ITextureStitchedCallback callback, ICallback.CallbackOption<TextureStitchedRegistry.ITextureStitchedCallbackPredicate> option) {
        Registries.textureStitchedRegtistry.registerCallback(callback, option);
    }

    @SideOnly(value=Side.CLIENT)
    public static void onRenderBlock(RenderBlockRegistry.IRenderBlockCallback callback, ICallback.CallbackOption<RenderBlockRegistry.IRenderBlockCallbackPredicate> option) {
        Registries.renderBlockRegistry.registerCallback(callback, option);
    }

    public static void onPreSetBlock(SetBlockCallbackRegistry.ISetBlockCallback callback, ICallback.CallbackOption<SetBlockCallbackRegistry.ISetBlockCallbackPredicate> option) {
        Registries.preSetBlockRegistry.registerCallback(callback, option);
    }

    public static void onPostSetBlock(SetBlockCallbackRegistry.ISetBlockCallback callback, ICallback.CallbackOption<SetBlockCallbackRegistry.ISetBlockCallbackPredicate> option) {
        Registries.postSetBlockRegistry.registerCallback(callback, option);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRenderer(Block block, IBlockRenderer renderer) {
        Registries.clientRegistry.blockRenderers.put((Block)Preconditions.checkNotNull((Object)block), (IBlockRenderer)Preconditions.checkNotNull((Object)renderer));
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            Registries.clientRegistry.itemRenderers.put(item, renderer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenderer(Item item, IItemRenderer renderer) {
        Registries.clientRegistry.itemRenderers.put((Item)Preconditions.checkNotNull((Object)item), (IItemRenderer)Preconditions.checkNotNull((Object)renderer));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderWorldLast(IRenderWorldLast renderer) {
        Registries.clientRegistry.renderWorldLastRenderers.add(renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void unregisterRenderWorldLast(IRenderWorldLast renderer) {
        Registries.clientRegistry.renderWorldLastRenderers.remove(renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRendererOverride(ClientRegistry.BlockRendererOverride override) {
        Registries.clientRegistry.blockRendererOverrides.add((ClientRegistry.BlockRendererOverride)Preconditions.checkNotNull((Object)override));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRendererOverride(ClientRegistry.ItemRendererOverride override) {
        Registries.clientRegistry.itemRendererOverrides.add((ClientRegistry.ItemRendererOverride)Preconditions.checkNotNull((Object)override));
    }

    public static SoundEvent registerSound(String modId, String soundId) {
        ResourceLocation rl = new ResourceLocation(modId, soundId);
        SoundEvent sound = new SoundEvent(rl);
        sound.setRegistryName(rl);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)sound);
        return sound;
    }
}

