/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import java.util.function.Function;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.minecraft.client.gui.GuiScreen;

public class UIPasswordField
extends UITextField {
    private char passwordChar = (char)42;
    private StringBuilder password = new StringBuilder();

    public UIPasswordField(MalisisGui gui) {
        super(gui, null, false);
    }

    public UIPasswordField(MalisisGui gui, char passwordChar) {
        this(gui);
        this.passwordChar = passwordChar;
    }

    public char getPasswordCharacter() {
        return this.passwordChar;
    }

    public void setPasswordCharacter(char passwordChar) {
        this.passwordChar = passwordChar;
    }

    @Override
    public String getText() {
        return this.password.toString();
    }

    protected void updateText() {
        this.text.setLength(0);
        this.text.append(this.password.toString().replaceAll("(?s).", String.valueOf(this.passwordChar)));
    }

    @Override
    public void addText(String text) {
        if (this.selectingText) {
            this.deleteSelectedText();
        }
        StringBuilder oldText = this.password;
        String oldValue = oldText.toString();
        String newValue = oldText.insert(this.cursorPosition.textPosition, text).toString();
        if (this.filterFunction != null) {
            newValue = (String)this.filterFunction.apply(newValue);
        }
        if (!this.fireEvent(new ComponentEvent.ValueChange<UIPasswordField, String>(this, oldValue, newValue))) {
            return;
        }
        this.password = new StringBuilder(newValue);
        this.cursorPosition.jumpBy(text.length());
        this.updateText();
    }

    @Override
    public void setText(String text) {
        if (this.filterFunction != null) {
            text = (String)this.filterFunction.apply(text);
        }
        this.password.setLength(0);
        this.password.append(text);
        this.selectingText = false;
        if (this.focused) {
            this.cursorPosition.jumpToEnd();
        }
        this.updateText();
    }

    @Override
    public void setFilter(Function<String, String> filterFunction) {
        this.filterFunction = filterFunction;
        this.password = new StringBuilder((String)this.filterFunction.apply(this.password.toString()));
    }

    @Override
    public void deleteSelectedText() {
        if (!this.selectingText) {
            return;
        }
        int start = Math.min(this.selectionPosition.textPosition, this.cursorPosition.textPosition);
        int end = Math.max(this.selectionPosition.textPosition, this.cursorPosition.textPosition);
        this.password.delete(start, end);
        this.selectingText = false;
        this.cursorPosition.jumpTo(start);
        this.updateText();
    }

    @Override
    protected boolean handleCtrlKeyDown(int keyCode) {
        return GuiScreen.func_146271_m() && keyCode != 46 && keyCode != 45 && super.handleCtrlKeyDown(keyCode);
    }
}

