/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.asm;

import net.malisis.core.util.parser.Parser;
import net.malisis.core.util.parser.token.Token;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableObject;

public class MethodDescriptor {
    private Class<?>[] params;
    private Class<?> returnType;

    public MethodDescriptor(Class<?> returnType, Class<?> ... params) {
        this.params = params;
        this.returnType = returnType;
    }

    public MethodDescriptor(String descriptor) {
        new MethodSignatureParser(this, descriptor).parse();
    }

    public Class<?>[] getParams() {
        return this.params;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public String toString() {
        String str = "(";
        if (this.params != null) {
            for (Class<?> c : this.params) {
                str = str + c.getName();
            }
        }
        str = str + ")";
        if (this.returnType != null) {
            str = str + this.returnType.getName();
        }
        return str;
    }

    static /* synthetic */ Class[] access$102(MethodDescriptor x0, Class[] x1) {
        x0.params = x1;
        return x1;
    }

    private static class TypeToken
    extends Token<Class<?>> {
        private static TypeToken token = (TypeToken)new TypeToken().name("TypeToken");
        private int size;

        private TypeToken() {
        }

        @Override
        public boolean matches(String s, int index) {
            this.value = null;
            this.size = 1;
            char c = s.charAt(index);
            switch (c) {
                case 'Z': {
                    this.value = Boolean.TYPE;
                    break;
                }
                case 'B': {
                    this.value = Byte.TYPE;
                    break;
                }
                case 'C': {
                    this.value = Character.TYPE;
                    break;
                }
                case 'S': {
                    this.value = Short.TYPE;
                    break;
                }
                case 'I': {
                    this.value = Integer.TYPE;
                    break;
                }
                case 'J': {
                    this.value = Long.TYPE;
                    break;
                }
                case 'F': {
                    this.value = Float.TYPE;
                    break;
                }
                case 'D': {
                    this.value = Double.TYPE;
                    break;
                }
                case 'V': {
                    this.value = Void.TYPE;
                    break;
                }
                case 'L': 
                case '[': {
                    this.value = this.getClass(s, index);
                }
            }
            return this.value != null;
        }

        private Class<?> getClass(String s, int index) {
            boolean isArray = s.charAt(index) == '[';
            int e = s.indexOf(59, index);
            if (e == -1) {
                return null;
            }
            try {
                String name = s.substring(isArray ? index : index + 1, isArray ? e + 1 : e).replace('/', '.');
                this.size = name.length() + (isArray ? 0 : 2);
                return Class.forName(name);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
                return null;
            }
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private static class MethodSignatureParser
    extends Parser<MethodDescriptor> {
        MethodDescriptor desc;

        public MethodSignatureParser(MethodDescriptor desc, String s) {
            super(s);
            this.desc = desc;
            this.withTokens(TypeToken.token, Token.Colon, Token.OpenCar, Token.OpenPar, Token.ClosePar);
        }

        @Override
        public MethodDescriptor parse() {
            boolean isParam = true;
            MutableObject clazz = new MutableObject();
            while (!this.isEnd()) {
                if (this.match(Token.OpenPar)) {
                    isParam = true;
                    continue;
                }
                if (this.match(Token.ClosePar)) {
                    if (!isParam) {
                        this.error(Token.OpenPar);
                    }
                    isParam = false;
                    continue;
                }
                if (this.match(TypeToken.token, clazz)) {
                    if (isParam) {
                        MethodDescriptor.access$102(this.desc, (Class[])ArrayUtils.add((Object[])this.desc.params, (Object)clazz.getValue()));
                        continue;
                    }
                    this.desc.returnType = (Class)clazz.getValue();
                    continue;
                }
                this.readToken();
            }
            return this.desc;
        }
    }
}

