/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class BlueprintEntityInfoTransformHandler {
    private static BlueprintEntityInfoTransformHandler ourInstance = new BlueprintEntityInfoTransformHandler();
    private Map<Predicate<NBTTagCompound>, Function<NBTTagCompound, NBTTagCompound>> entityInfoTransformHandler = new HashMap<Predicate<NBTTagCompound>, Function<NBTTagCompound, NBTTagCompound>>();

    public static BlueprintEntityInfoTransformHandler getInstance() {
        return ourInstance;
    }

    private BlueprintEntityInfoTransformHandler() {
    }

    public void AddTransformHandler(@NotNull Predicate<NBTTagCompound> transformPredicate, @NotNull Function<NBTTagCompound, NBTTagCompound> transformHandler) {
        this.entityInfoTransformHandler.put(transformPredicate, transformHandler);
    }

    public NBTTagCompound Transform(@NotNull NBTTagCompound entityInfo) {
        return this.getTransformHandler(entityInfo).apply(entityInfo);
    }

    private Function<NBTTagCompound, NBTTagCompound> getTransformHandler(@NotNull NBTTagCompound entityInfo) {
        return this.entityInfoTransformHandler.keySet().stream().filter(p -> p.test(entityInfo)).findFirst().map(p -> this.entityInfoTransformHandler.get(p)).orElse(Function.identity());
    }
}

