/*
 * Decompiled with CFR 0.152.
 */
package net.smart.utilities;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.smart.utilities.Name;

public class Reflect {
    public static Object NewInstance(Class<?> base, Name name) {
        try {
            return Reflect.LoadClass(base, name, true).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(name.deobfuscated, e);
        }
    }

    public static boolean CheckClasses(Class<?> base, Name ... names) {
        for (int i = 0; i < names.length; ++i) {
            if (Reflect.LoadClass(base, names[i], false) != null) continue;
            return false;
        }
        return true;
    }

    public static Class<?> LoadClass(Class<?> base, Name name, boolean throwException) {
        ClassLoader loader = base.getClassLoader();
        if (name.obfuscated != null) {
            try {
                return loader.loadClass(name.obfuscated);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return loader.loadClass(name.deobfuscated);
        }
        catch (ClassNotFoundException cnfe) {
            if (throwException) {
                throw new RuntimeException(cnfe);
            }
            return null;
        }
    }

    public static void SetField(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object GetField(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void SetField(Class<?> theClass, Object object, Name name, Object value) {
        try {
            Reflect.GetField(theClass, name).set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object GetField(Class<?> theClass, Object object, Name name) {
        try {
            return Reflect.GetField(theClass, name).get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field GetField(Class<?> theClass, Name name) {
        return Reflect.GetField(theClass, name, true);
    }

    public static Field GetField(Class<?> theClass, Name name, boolean throwException) {
        Field field;
        block3: {
            if (theClass == null && !throwException) {
                return null;
            }
            field = null;
            try {
                field = Reflect.GetRawField(theClass, name);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException oe) {
                if (!throwException) break block3;
                throw new RuntimeException(Reflect.GetFieldMessage(theClass, name), oe);
            }
        }
        return field;
    }

    private static String GetFieldMessage(Class<?> theClass, Name name) {
        Field[] fields = theClass.getDeclaredFields();
        StringBuffer message = Reflect.GetMessage(theClass, name, "field");
        for (int i = 0; i < fields.length; ++i) {
            Reflect.AppendField(message, fields[i]);
        }
        return message.toString();
    }

    private static Field GetRawField(Class<?> theClass, Name name) throws NoSuchFieldException {
        if (name.obfuscated != null) {
            try {
                return theClass.getDeclaredField(name.obfuscated);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (name.forgefuscated != null) {
            try {
                return theClass.getDeclaredField(name.forgefuscated);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return theClass.getDeclaredField(name.deobfuscated);
    }

    public static Method GetMethod(Class<?> theClass, Name name, Class<?> ... paramArrayOfClass) {
        return Reflect.GetMethod(theClass, name, true, paramArrayOfClass);
    }

    public static Method GetMethod(Class<?> theClass, Name name, boolean throwException, Class<?> ... paramArrayOfClass) {
        Method method;
        block3: {
            if (theClass == null && !throwException) {
                return null;
            }
            method = null;
            try {
                method = Reflect.GetRawMethod(theClass, name, paramArrayOfClass);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException oe) {
                if (!throwException) break block3;
                throw new RuntimeException(Reflect.GetMethodMessage(theClass, name), oe);
            }
        }
        return method;
    }

    private static String GetMethodMessage(Class<?> theClass, Name name) {
        Method[] methods = theClass.getDeclaredMethods();
        StringBuffer message = Reflect.GetMessage(theClass, name, "method");
        for (int i = 0; i < methods.length; ++i) {
            Reflect.AppendMethod(message, methods[i]);
        }
        return message.toString();
    }

    private static Method GetRawMethod(Class<?> theClass, Name name, Class<?> ... paramArrayOfClass) throws NoSuchMethodException {
        if (name.obfuscated != null) {
            try {
                return theClass.getDeclaredMethod(name.obfuscated, paramArrayOfClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (name.forgefuscated != null) {
            try {
                return theClass.getDeclaredMethod(name.forgefuscated, paramArrayOfClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return theClass.getDeclaredMethod(name.deobfuscated, paramArrayOfClass);
    }

    public static Object Invoke(Method method, Object paramObject, Object ... paramArrayOfObject) {
        try {
            return method.invoke(paramObject, paramArrayOfObject);
        }
        catch (Exception e) {
            throw new RuntimeException(method.getName(), e);
        }
    }

    private static StringBuffer GetMessage(Class<?> theClass, Name name, String elementName) {
        StringBuffer message = new StringBuffer().append("Can not find ").append(elementName).append(" \"").append(name.deobfuscated).append("\"");
        if (name.obfuscated != null) {
            message.append(" (ofuscated \"").append(name.obfuscated).append("\")");
        }
        message.append(" in class \"").append(theClass.getName()).append("\".\nExisting ").append(elementName).append("s are:");
        return message;
    }

    private static void AppendMethod(StringBuffer message, Method method) {
        message.append("\n\t\t").append(method.getReturnType().getName()).append(" ").append(method.getName()).append("(");
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                message.append(", ");
            }
            message.append(types[i].getName());
        }
        message.append(")");
    }

    private static void AppendField(StringBuffer message, Field field) {
        message.append("\n\t\t").append(field.getType().getName()).append(" ").append(field.getName());
    }
}

