/*
 * Decompiled with CFR 0.152.
 */
package net.smart.render.statistics;

import java.util.Hashtable;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.smart.render.statistics.IEntityPlayerSP;
import net.smart.render.statistics.SmartStatistics;
import net.smart.render.statistics.SmartStatisticsOther;

public class SmartStatisticsFactory {
    private static SmartStatisticsFactory factory;
    private Hashtable<Integer, SmartStatisticsOther> otherStatistics;

    public SmartStatisticsFactory() {
        if (factory != null) {
            throw new RuntimeException("FATAL: Can only create one instance of type 'StatisticsFactory'");
        }
        factory = this;
    }

    protected static boolean isInitialized() {
        return factory != null;
    }

    public static void initialize() {
        if (!SmartStatisticsFactory.isInitialized()) {
            new SmartStatisticsFactory();
        }
    }

    public static void handleMultiPlayerTick(Minecraft minecraft) {
        factory.doHandleMultiPlayerTick(minecraft);
    }

    public static SmartStatistics getInstance(EntityPlayer entityPlayer) {
        return factory.doGetInstance(entityPlayer);
    }

    public static SmartStatisticsOther getOtherStatistics(int entityId) {
        return factory.doGetOtherStatistics(entityId);
    }

    public static SmartStatisticsOther getOtherStatistics(EntityOtherPlayerMP entity) {
        return factory.doGetOtherStatistics(entity);
    }

    protected void doHandleMultiPlayerTick(Minecraft minecraft) {
        SmartStatisticsOther statistics;
        for (Entity player : minecraft.field_71441_e.field_73010_i) {
            if (!(player instanceof EntityOtherPlayerMP)) continue;
            EntityOtherPlayerMP otherPlayer = (EntityOtherPlayerMP)player;
            statistics = this.doGetOtherStatistics(otherPlayer);
            statistics.calculateAllStats(true);
            statistics.foundAlive = true;
        }
        if (this.otherStatistics == null || this.otherStatistics.isEmpty()) {
            return;
        }
        Iterator<Integer> entityIds = this.otherStatistics.keySet().iterator();
        while (entityIds.hasNext()) {
            Integer entityId = entityIds.next();
            statistics = this.otherStatistics.get(entityId);
            if (statistics.foundAlive) {
                statistics.foundAlive = false;
                continue;
            }
            entityIds.remove();
        }
    }

    protected SmartStatistics doGetInstance(EntityPlayer entityPlayer) {
        if (entityPlayer instanceof EntityOtherPlayerMP) {
            return this.doGetOtherStatistics(entityPlayer.func_145782_y());
        }
        if (entityPlayer instanceof IEntityPlayerSP) {
            return ((IEntityPlayerSP)entityPlayer).getStatistics();
        }
        return null;
    }

    protected SmartStatisticsOther doGetOtherStatistics(int entityId) {
        Entity entity;
        SmartStatisticsOther statistics = this.tryGetOtherStatistics(entityId);
        if (statistics == null && (entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityId)) != null && entity instanceof EntityOtherPlayerMP) {
            statistics = this.addOtherStatistics((EntityOtherPlayerMP)entity);
        }
        return statistics;
    }

    protected SmartStatisticsOther doGetOtherStatistics(EntityOtherPlayerMP entity) {
        SmartStatisticsOther statistics = this.tryGetOtherStatistics(entity.func_145782_y());
        if (statistics == null) {
            statistics = this.addOtherStatistics(entity);
        }
        return statistics;
    }

    protected final SmartStatisticsOther tryGetOtherStatistics(int entityId) {
        if (this.otherStatistics == null) {
            this.otherStatistics = new Hashtable();
        }
        return this.otherStatistics.get(entityId);
    }

    protected final SmartStatisticsOther addOtherStatistics(EntityOtherPlayerMP entity) {
        SmartStatisticsOther statistics = new SmartStatisticsOther(entity);
        this.otherStatistics.put(entity.func_145782_y(), statistics);
        return statistics;
    }
}

