/*
 * Decompiled with CFR 0.152.
 */
package net.smart.render.render;

import api.player.model.ModelPlayerAPI;
import api.player.render.RenderPlayerAPI;
import api.player.render.RenderPlayerBase;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerEntityOnShoulder;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.smart.render.SRContext;
import net.smart.render.SRInstall;
import net.smart.render.model.IModelPlayer;
import net.smart.render.render.IRenderPlayer;
import net.smart.render.render.SRLayerCustomHead;
import net.smart.render.render.SRLayerElytra;
import net.smart.render.render.SRLayerEntityOnShoulder;
import net.smart.render.render.SRRenderer;
import net.smart.utilities.Reflect;

public class SRRenderPlayerBase
extends RenderPlayerBase
implements IRenderPlayer {
    private SRRenderer renderer;
    private ModelBiped[] allModelPlayers;
    private IModelPlayer[] allIModelPlayers;
    private static final Field _modelArmor = Reflect.GetField(LayerArmorBase.class, SRInstall.LayerArmorBase_modelArmor);
    private static final Field _layerRenderers = Reflect.GetField(RenderLivingBase.class, SRInstall.RenderLivingBase_layerRenderers);

    public SRRenderPlayerBase(RenderPlayerAPI renderPlayerAPI) {
        super(renderPlayerAPI);
    }

    private SRRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new SRRenderer(this);
        }
        return this.renderer;
    }

    @Override
    public IModelPlayer createModel(ModelBiped existing, float f, boolean b) {
        return SRContext.getPlayerBase(existing);
    }

    @Override
    public boolean getSmallArms() {
        return this.renderPlayerAPI.getSmallArmsField();
    }

    @Override
    public void initialize(ModelPlayer modelBipedMain, ModelBiped modelArmor) {
        List layerRenderers = (List)Reflect.GetField(_layerRenderers, this.renderPlayer);
        layerRenderers.removeIf(layer -> layer.getClass() == LayerElytra.class || layer.getClass() == LayerCustomHead.class || layer.getClass() == LayerEntityOnShoulder.class);
        this.renderPlayer.func_177094_a((LayerRenderer)new SRLayerEntityOnShoulder(this.renderPlayer.func_177068_d(), this));
        this.renderPlayer.func_177094_a((LayerRenderer)new SRLayerElytra((RenderLivingBase<?>)this.renderPlayer, this));
        this.renderPlayer.func_177094_a((LayerRenderer)new SRLayerCustomHead(modelBipedMain.field_78116_c));
    }

    public void doRender(AbstractClientPlayer entityplayer, double d, double d1, double d2, float f, float renderPartialTicks) {
        this.getRenderer().doRender(entityplayer, d, d1, d2, f, renderPartialTicks);
    }

    @Override
    public void superDoRender(AbstractClientPlayer entityplayer, double d, double d1, double d2, float f, float renderPartialTicks) {
        super.doRender(entityplayer, d, d1, d2, f, renderPartialTicks);
    }

    public void rotateCorpse(AbstractClientPlayer entityplayer, float totalTime, float actualRotation, float f2) {
        this.getRenderer().rotateCorpse(entityplayer, totalTime, actualRotation, f2);
    }

    @Override
    public void superRotateCorpse(AbstractClientPlayer entityplayer, float totalTime, float actualRotation, float f2) {
        super.rotateCorpse(entityplayer, totalTime, actualRotation, f2);
    }

    public void renderLayers(AbstractClientPlayer entityPlayer, float f1, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.getRenderer().renderSpecials(entityPlayer, f1, f2, f3, f4, f5, f6, f7);
    }

    @Override
    public void superRenderSpecials(AbstractClientPlayer entityPlayer, float f1, float f2, float f3, float f4, float f5, float f6, float f7) {
        super.renderLayers(entityPlayer, f1, f2, f3, f4, f5, f6, f7);
    }

    public void beforeHandleRotationFloat(AbstractClientPlayer entityliving, float f) {
        this.getRenderer().beforeHandleRotationFloat(entityliving, f);
    }

    public void afterHandleRotationFloat(AbstractClientPlayer entityliving, float f) {
        this.getRenderer().afterHandleRotationFloat(entityliving, f);
    }

    @Override
    public RenderManager getRenderRenderManager() {
        return this.renderPlayerAPI.getRenderManagerField();
    }

    @Override
    public ModelPlayer getModelBipedMain() {
        return this.renderPlayer.func_177087_b();
    }

    @Override
    public ModelBiped getModelArmor() {
        for (Object layer : this.renderPlayerAPI.getLayerRenderersField()) {
            if (!(layer instanceof LayerArmorBase)) continue;
            return (ModelBiped)Reflect.GetField(_modelArmor, layer);
        }
        return null;
    }

    @Override
    public IModelPlayer[] getRenderModels() {
        ModelBiped[] modelPlayers = ModelPlayerAPI.getAllInstances();
        if (this.allModelPlayers != null && (this.allModelPlayers == modelPlayers || modelPlayers.length == 0 && this.allModelPlayers.length == 0)) {
            return this.allIModelPlayers;
        }
        this.allModelPlayers = modelPlayers;
        this.allIModelPlayers = new IModelPlayer[modelPlayers.length];
        for (int i = 0; i < this.allIModelPlayers.length; ++i) {
            this.allIModelPlayers[i] = SRContext.getPlayerBase(this.allModelPlayers[i]);
        }
        return this.allIModelPlayers;
    }
}

