/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.shaded.hammerlib.cfg;

import java.io.BufferedWriter;
import java.io.IOException;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryInt;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntrySerializer;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.Configuration;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ReaderHelper;

public class ConfigSerializerInt
extends ConfigEntrySerializer<ConfigEntryInt> {
    public ConfigSerializerInt() {
        super("I");
    }

    @Override
    public void write(Configuration config, BufferedWriter writer, ConfigEntryInt entry, int indents) throws IOException {
        if (entry.getDescription() != null) {
            this.writeComment(writer, entry.getDescription() + " (Default: " + entry.initialValue + ", Range: [" + entry.min + ";" + entry.max + "])", indents);
        }
        this.writeIndents(writer, indents);
        writer.write("+" + this.type + ":" + entry.getSerializedName() + "=" + entry.getValue() + "\n\n");
    }

    @Override
    public ConfigEntryInt read(Configuration config, ReaderHelper reader, int indents) throws IOException {
        ConfigEntryInt lnt = new ConfigEntryInt(config, null);
        reader.until('+', true);
        if (reader.eat(this.type, true) && reader.eat(':', true)) {
            String name = reader.until('=', true);
            String value = reader.getRest();
            if (value.contains("\n")) {
                value = value.substring(0, value.indexOf(10));
            }
            lnt.name = name;
            try {
                lnt.value = Math.max(lnt.min, Math.min(lnt.max, Integer.parseInt(value)));
            }
            catch (NumberFormatException nfe) {
                lnt.value = null;
            }
        }
        return lnt;
    }
}

