/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.api;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.INBTSerializable;
import tk.zeitheron.solarflux.api.SolarFluxAPI;
import tk.zeitheron.solarflux.api.SolarInfo;
import tk.zeitheron.solarflux.block.tile.TileBaseSolar;

public class SolarInstance
implements INBTSerializable<NBTTagCompound> {
    public SolarInfo infoDelegate;
    public ResourceLocation delegate;
    public long gen;
    public long cap;
    public long transfer;
    public boolean valid = false;

    public SolarInfo getDelegate() {
        if (this.infoDelegate == null) {
            this.infoDelegate = (SolarInfo)SolarFluxAPI.SOLAR_PANELS.getValue(this.delegate);
            return this.infoDelegate;
        }
        return this.infoDelegate;
    }

    public float computeSunIntensity(TileBaseSolar solar) {
        if (this.getDelegate() != null) {
            return this.infoDelegate.computeSunIntensity(solar);
        }
        if (!solar.doesSeeSky()) {
            return 0.0f;
        }
        float celestialAngleRadians = solar.func_145831_w().func_72929_e(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
        }
        boolean lowLightCount = false;
        float multiplicator = 1.5f - (float)lowLightCount * 0.122f;
        float displacement = 1.2f + (float)lowLightCount * 0.08f;
        return MathHelper.func_76131_a((float)(multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement))), (float)0.0f, (float)1.0f);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void reset() {
        SolarInfo info = this.getDelegate();
        boolean bl = this.valid = info != null;
        if (this.valid) {
            info.accept(this);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Delegate", this.delegate.toString());
        return nbt;
    }

    public static SolarInstance deserialize(NBTTagCompound nbt) {
        SolarInstance inst = new SolarInstance();
        inst.deserializeNBT(nbt);
        return inst;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.delegate = new ResourceLocation(nbt.func_74779_i("Delegate"));
        this.reset();
    }
}

