/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigFluid;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigNBT;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FluidTask
extends Task {
    public static final ResourceLocation TANK_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/tank.png");
    public Fluid fluid = FluidRegistry.WATER;
    public NBTTagCompound fluidNBT = null;
    public int amount = 1000;

    public FluidTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.FLUID;
    }

    @Override
    public long getMaxProgress() {
        return this.amount;
    }

    @Override
    public String getMaxProgressString() {
        return FluidTask.getVolumeString(this.amount);
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("fluid", this.fluid.getName());
        if (this.amount != 1000) {
            nbt.func_74768_a("amount", this.amount);
        }
        if (this.fluidNBT != null) {
            nbt.func_74782_a("nbt", (NBTBase)this.fluidNBT);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.fluid = FluidRegistry.getFluid((String)nbt.func_74779_i("fluid"));
        if (this.fluid == null) {
            this.fluid = FluidRegistry.WATER;
        }
        this.fluidNBT = (NBTTagCompound)nbt.func_74781_a("nbt");
        int n = this.amount = nbt.func_74764_b("amount") ? (int)Math.min(Integer.MAX_VALUE, nbt.func_74763_f("amount")) : 1000;
        if (this.amount < 1) {
            this.amount = 1;
        }
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.fluid.getName());
        data.writeNBT(this.fluidNBT);
        data.writeVarInt(this.amount);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.fluid = FluidRegistry.getFluid((String)data.readString());
        if (this.fluid == null) {
            this.fluid = FluidRegistry.WATER;
        }
        this.fluidNBT = data.readNBT();
        this.amount = data.readVarInt();
    }

    public FluidStack createFluidStack(int amount) {
        return new FluidStack(this.fluid, amount, this.fluidNBT);
    }

    public static String getVolumeString(int a) {
        StringBuilder builder = new StringBuilder();
        if (a >= 1000) {
            if ((long)(a % 1000) != 0L) {
                builder.append((double)a / 1000.0);
            } else {
                builder.append(a / 1000);
            }
        } else {
            builder.append(a % 1000);
        }
        builder.append(' ');
        if (a < 1000) {
            builder.append('m');
        }
        builder.append('B');
        return builder.toString();
    }

    @Override
    public Icon getAltIcon() {
        FluidStack fluidStack = this.createFluidStack(1000);
        return Icon.getIcon((String)fluidStack.getFluid().getStill(fluidStack).toString()).withTint(Color4I.rgb((int)fluidStack.getFluid().getColor(fluidStack))).combineWith(Icon.getIcon((String)TANK_TEXTURE.toString()));
    }

    @Override
    public String getAltTitle() {
        return FluidTask.getVolumeString(this.amount) + " of " + this.createFluidStack(1000).getLocalizedName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.add("fluid", (ConfigValue)new ConfigFluid(FluidRegistry.WATER, FluidRegistry.WATER){

            public Fluid getFluid() {
                return FluidTask.this.fluid;
            }

            public void setFluid(Fluid v) {
                FluidTask.this.fluid = v;
            }
        }, (ConfigValue)new ConfigFluid(FluidRegistry.WATER, FluidRegistry.WATER));
        config.add("fluid_nbt", (ConfigValue)new ConfigNBT(null){

            @Nullable
            public NBTTagCompound getNBT() {
                return FluidTask.this.fluidNBT;
            }

            public void setNBT(@Nullable NBTTagCompound v) {
                FluidTask.this.fluidNBT = v;
            }
        }, (ConfigValue)new ConfigNBT(null));
        config.addInt("amount", () -> this.amount, v -> {
            this.amount = v;
        }, 1000, 1, Integer.MAX_VALUE);
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    public void drawScreen(@Nullable TaskData data) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(TANK_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double x = -0.5;
        double y = -0.5;
        double w = 1.0;
        double h = 1.0;
        double z = 0.0;
        buffer.func_181662_b(x, y + h, z).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y + h, z).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y, z).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x, y, z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        double d = r = data == null ? 0.0 : (double)data.progress / (double)((Task)data.task).getMaxProgress();
        if (r > 0.0) {
            x += 0.0078125;
            w -= 0.015625;
            h = r * 30.0 / 32.0;
            y = 0.03125 + (1.0 - r) * 30.0 / 32.0 - 0.5;
            y -= 0.0078125;
            h += 0.015625;
            z = 0.003;
            FluidStack stack = this.createFluidStack(1000);
            TextureAtlasSprite sprite = mc.func_147117_R().func_110572_b(stack.getFluid().getStill(stack).toString());
            int color = stack.getFluid().getColor(stack);
            int alpha = color >> 24 & 0xFF;
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            double u0 = sprite.func_94209_e();
            double v0 = (double)sprite.func_94206_g() + (double)(sprite.func_94210_h() - sprite.func_94206_g()) * (1.0 - r);
            double u1 = sprite.func_94212_f();
            double v1 = sprite.func_94210_h();
            mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(x, y + h, z).func_187315_a(u0, v1).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + w, y + h, z).func_187315_a(u1, v1).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + w, y, z).func_187315_a(u1, v0).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x, y, z).func_187315_a(u0, v0).func_181669_b(red, green, blue, alpha).func_181675_d();
            tessellator.func_78381_a();
            mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.createFluidStack(1000);
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<FluidTask>
    implements IFluidHandler,
    IFluidTankProperties {
        private IFluidTankProperties[] properties;

        private Data(FluidTask t, QuestData data) {
            super(t, data);
        }

        @Override
        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        @Override
        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null);
        }

        @Override
        public String getProgressString() {
            return FluidTask.getVolumeString((int)this.progress);
        }

        public IFluidTankProperties[] getTankProperties() {
            if (this.properties == null) {
                this.properties = new IFluidTankProperties[1];
                this.properties[0] = this;
            }
            return this.properties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            int add;
            if (resource.amount > 0 && !this.isComplete() && ((FluidTask)this.task).fluid == resource.getFluid() && Objects.equals(((FluidTask)this.task).fluidNBT, resource.tag) && ((FluidTask)this.task).quest.canStartTasks(this.data) && (add = (int)Math.min((long)resource.amount, (long)((FluidTask)this.task).amount - this.progress)) > 0) {
                if (doFill && !this.data.getFile().isClient()) {
                    this.addProgress(add);
                }
                return add;
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        @Override
        public ItemStack insertItem(ItemStack stack, boolean singleItem, boolean simulate, @Nullable EntityPlayer player) {
            ItemStack stack1;
            FluidActionResult result;
            IItemHandler inv;
            if (this.isComplete()) {
                return stack;
            }
            IFluidHandlerItem handlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (handlerItem == null) {
                return stack;
            }
            FluidStack toDrain = ((FluidTask)this.task).createFluidStack(1000);
            FluidStack drainedFluid = handlerItem.drain(toDrain, false);
            if (drainedFluid == null || drainedFluid.amount <= 0) {
                return stack;
            }
            IItemHandler iItemHandler = inv = player == null ? null : (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (inv == null) {
                inv = ItemDestroyingInventory.INSTANCE;
            }
            if (!(result = FluidUtil.tryFillContainerAndStow((ItemStack)(stack1 = stack.func_77946_l()), (IFluidHandler)this, (IItemHandler)inv, (int)Integer.MAX_VALUE, (EntityPlayer)player, (!simulate ? 1 : 0) != 0)).isSuccess()) {
                result = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack1, (IFluidHandler)this, (IItemHandler)inv, (int)Integer.MAX_VALUE, (EntityPlayer)player, (!simulate ? 1 : 0) != 0);
            }
            if (result.isSuccess()) {
                return player == null ? ItemStack.field_190927_a : result.getResult();
            }
            return stack;
        }

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nullable
        public FluidStack getContents() {
            return ((FluidTask)this.task).createFluidStack((int)this.progress);
        }

        public int getCapacity() {
            return ((FluidTask)this.task).amount;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return false;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return ((FluidTask)this.task).fluid == fluidStack.getFluid() && Objects.equals(((FluidTask)this.task).fluidNBT, fluidStack.tag);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return false;
        }
    }

    public static enum ItemDestroyingInventory implements IItemHandler
    {
        INSTANCE;


        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }
}

