/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.gamestages;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.integration.gamestages.GameStagesIntegration;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GameStageReward
extends Reward {
    public String stage = "";
    public boolean remove = false;

    public GameStageReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return GameStagesIntegration.GAMESTAGE_REWARD;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("stage", this.stage);
        if (this.remove) {
            nbt.func_74757_a("remove", true);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.stage = nbt.func_74779_i("stage");
        this.remove = nbt.func_74767_n("remove");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.stage);
        data.writeBoolean(this.remove);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.stage = data.readString();
        this.remove = data.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("stage", () -> this.stage, v -> {
            this.stage = v;
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbquests.gamestage", new Object[0]));
        config.addBool("remove", () -> this.remove, v -> {
            this.remove = v;
        }, false);
    }

    @Override
    public void claim(EntityPlayerMP player, boolean notify) {
        if (this.remove) {
            GameStageHelper.removeStage((EntityPlayer)player, (String)this.stage);
        } else {
            GameStageHelper.addStage((EntityPlayer)player, (String)this.stage);
        }
        GameStageHelper.syncPlayer((EntityPlayerMP)player);
        if (notify) {
            if (this.remove) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.gamestage.remove.target", new Object[]{this.stage}));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.gamestage.add.target", new Object[]{this.stage}));
            }
        }
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.reward.ftbquests.gamestage", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + this.stage;
    }
}

