/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.tree.ButtonChapterImage;
import com.feed_the_beast.ftbquests.gui.tree.ButtonQuest;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateTaskAt;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.ChapterImage;
import com.feed_the_beast.ftbquests.quest.Movable;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public class PanelQuests
extends Panel {
    private static final ImageIcon DEFAULT_DEPENDENCY_LINE_TEXTURE = (ImageIcon)Icon.getIcon((String)"ftbquests:textures/gui/dependency.png");
    public final GuiQuestTree treeGui;
    public double questX = 0.0;
    public double questY = 0.0;
    public double centerQuestX = 0.0;
    public double centerQuestY = 0.0;
    public ButtonQuest mouseOverQuest = null;
    public double questMinX;
    public double questMinY;
    public double questMaxX;
    public double questMaxY;

    public PanelQuests(Panel panel) {
        super(panel);
        this.treeGui = (GuiQuestTree)panel.getGui();
    }

    public void updateMinMax() {
        this.questMinX = Double.POSITIVE_INFINITY;
        this.questMinY = Double.POSITIVE_INFINITY;
        this.questMaxX = Double.NEGATIVE_INFINITY;
        this.questMaxY = Double.NEGATIVE_INFINITY;
        for (Widget w : this.widgets) {
            double qh;
            double qw;
            double qy;
            double qx;
            Movable q;
            if (w instanceof ButtonQuest) {
                q = ((ButtonQuest)w).quest;
                qx = q.x;
                qy = q.y;
                qw = q.size;
                qh = q.size;
            } else {
                if (!(w instanceof ButtonChapterImage)) continue;
                q = ((ButtonChapterImage)w).chapterImage;
                qx = ((ChapterImage)q).x;
                qy = ((ChapterImage)q).y;
                qw = ((ChapterImage)q).width;
                qh = ((ChapterImage)q).height;
            }
            this.questMinX = Math.min(this.questMinX, qx - qw / 2.0);
            this.questMinY = Math.min(this.questMinY, qy - qh / 2.0);
            this.questMaxX = Math.max(this.questMaxX, qx + qw / 2.0);
            this.questMaxY = Math.max(this.questMaxY, qy + qh / 2.0);
        }
        if (this.questMinX == Double.POSITIVE_INFINITY) {
            this.questMaxY = 0.0;
            this.questMaxX = 0.0;
            this.questMinY = 0.0;
            this.questMinX = 0.0;
        }
        this.questMinX -= 40.0;
        this.questMinY -= 30.0;
        this.questMaxX += 40.0;
        this.questMaxY += 30.0;
    }

    public void scrollTo(double x, double y) {
        this.updateMinMax();
        double dx = this.questMaxX - this.questMinX;
        double dy = this.questMaxY - this.questMinY;
        this.setScrollX((x - this.questMinX) / dx * this.treeGui.scrollWidth - (double)this.width / 2.0);
        this.setScrollY((y - this.questMinY) / dy * this.treeGui.scrollHeight - (double)this.height / 2.0);
    }

    public void resetScroll() {
        this.alignWidgets();
        this.setScrollX((this.treeGui.scrollWidth - (double)this.width) / 2.0);
        this.setScrollY((this.treeGui.scrollHeight - (double)this.height) / 2.0);
    }

    public void addWidgets() {
        if (this.treeGui.selectedChapter == null) {
            return;
        }
        for (Quest quest : this.treeGui.selectedChapter.quests) {
            if (!this.treeGui.file.canEdit() && !quest.isVisible(ClientQuestFile.INSTANCE.self)) continue;
            this.add((Widget)new ButtonQuest(this, quest));
        }
        for (ChapterImage image : this.treeGui.selectedChapter.images) {
            this.add((Widget)new ButtonChapterImage(this, image));
        }
        this.alignWidgets();
    }

    public void alignWidgets() {
        if (this.treeGui.selectedChapter == null) {
            return;
        }
        this.treeGui.scrollWidth = 0.0;
        this.treeGui.scrollHeight = 0.0;
        this.updateMinMax();
        double bs = this.treeGui.getQuestButtonSize();
        double bp = this.treeGui.getQuestButtonSpacing();
        this.treeGui.scrollWidth = (this.questMaxX - this.questMinX) * (bs + bp);
        this.treeGui.scrollHeight = (this.questMaxY - this.questMinY) * (bs + bp);
        for (Widget w : this.widgets) {
            double qh;
            double qw;
            double qy;
            double qx;
            Movable q;
            if (w instanceof ButtonQuest) {
                q = ((ButtonQuest)w).quest;
                qx = q.x;
                qy = q.y;
                qw = q.size;
                qh = q.size;
            } else {
                if (!(w instanceof ButtonChapterImage)) continue;
                q = ((ButtonChapterImage)w).chapterImage;
                qx = ((ChapterImage)q).x;
                qy = ((ChapterImage)q).y;
                qw = ((ChapterImage)q).width;
                qh = ((ChapterImage)q).height;
            }
            double x = (qx - this.questMinX - qw / 2.0) * (bs + bp) + bp / 2.0 + bp * (qw - 1.0) / 2.0;
            double y = (qy - this.questMinY - qh / 2.0) * (bs + bp) + bp / 2.0 + bp * (qh - 1.0) / 2.0;
            w.setPosAndSize((int)x, (int)y, (int)(bs * qw), (int)(bs * qh));
        }
        this.setPosAndSize(20, 1, this.treeGui.width - 40, this.treeGui.height - 2);
    }

    public void drawOffsetBackground(Theme theme, int x, int y, int w, int h) {
        Quest wquest;
        if (this.treeGui.selectedChapter == null) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Icon icon = (Icon)ThemeProperties.DEPENDENCY_LINE_TEXTURE.get(this.treeGui.selectedChapter);
        if (icon instanceof ImageIcon) {
            icon.bindTexture();
        } else {
            DEFAULT_DEPENDENCY_LINE_TEXTURE.bindTexture();
        }
        Quest selectedQuest = this.treeGui.getViewedQuest();
        GlStateManager.func_179103_j((int)7425);
        double mt = -((double)System.currentTimeMillis() * 0.001);
        double mu = mt * (Double)ThemeProperties.DEPENDENCY_LINE_UNSELECTED_SPEED.get(this.treeGui.selectedChapter) % 1.0;
        double ms = mt * (Double)ThemeProperties.DEPENDENCY_LINE_SELECTED_SPEED.get(this.treeGui.selectedChapter) % 1.0;
        double s = (double)this.treeGui.getZoom() * (Double)ThemeProperties.DEPENDENCY_LINE_THICKNESS.get(this.treeGui.selectedChapter) / 4.0 * 3.0;
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ButtonQuest)) continue;
            wquest = ((ButtonQuest)widget).quest;
            if (wquest.hideDependencyLines) continue;
            boolean unavailable = this.treeGui.file.self == null || !wquest.canStartTasks(this.treeGui.file.self);
            boolean complete = !unavailable && this.treeGui.file.self != null && wquest.isComplete(this.treeGui.file.self);
            for (ButtonQuest button : ((ButtonQuest)widget).getDependencies()) {
                int a;
                int b;
                int g;
                int r;
                Color4I c;
                if (button.quest == selectedQuest || wquest == selectedQuest) continue;
                if (complete) {
                    c = (Color4I)ThemeProperties.DEPENDENCY_LINE_COMPLETED_COLOR.get(this.treeGui.selectedChapter);
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = c.alphai();
                } else {
                    c = Color4I.hsb((float)((float)button.quest.id / 1000.0f), (float)0.2f, (float)(unavailable ? 0.3f : 0.8f));
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = 180;
                }
                double sx = (double)widget.getX() + (double)widget.width / 2.0;
                double sy = (double)widget.getY() + (double)widget.height / 2.0;
                double ex = (double)button.getX() + (double)button.width / 2.0;
                double ey = (double)button.getY() + (double)button.height / 2.0;
                double len = MathUtils.dist((double)sx, (double)sy, (double)ex, (double)ey);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)sx, (double)sy, (double)0.0);
                GlStateManager.func_179114_b((float)((float)(Math.atan2(ey - sy, ex - sx) * 180.0 / Math.PI)), (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_181662_b(0.0, -s, 0.0).func_187315_a(len / s / 2.0 + mu, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(0.0, s, 0.0).func_187315_a(len / s / 2.0 + mu, 1.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(len, s, 0.0).func_187315_a(mu, 1.0).func_181669_b(r * 3 / 4, g * 3 / 4, b * 3 / 4, a).func_181675_d();
                buffer.func_181662_b(len, -s, 0.0).func_187315_a(mu, 0.0).func_181669_b(r * 3 / 4, g * 3 / 4, b * 3 / 4, a).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
        }
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ButtonQuest)) continue;
            wquest = ((ButtonQuest)widget).quest;
            if (wquest.hideDependencyLines) continue;
            for (ButtonQuest button : ((ButtonQuest)widget).getDependencies()) {
                int a;
                int b;
                int g;
                int r;
                Color4I c;
                if (button.quest == selectedQuest) {
                    c = (Color4I)ThemeProperties.DEPENDENCY_LINE_REQUIRED_FOR_COLOR.get(this.treeGui.selectedChapter);
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = c.alphai();
                } else {
                    if (wquest != selectedQuest) continue;
                    c = (Color4I)ThemeProperties.DEPENDENCY_LINE_REQUIRES_COLOR.get(this.treeGui.selectedChapter);
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = c.alphai();
                }
                double sx = (double)widget.getX() + (double)widget.width / 2.0;
                double sy = (double)widget.getY() + (double)widget.height / 2.0;
                double ex = (double)button.getX() + (double)button.width / 2.0;
                double ey = (double)button.getY() + (double)button.height / 2.0;
                double len = MathUtils.dist((double)sx, (double)sy, (double)ex, (double)ey);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)sx, (double)sy, (double)0.0);
                GlStateManager.func_179114_b((float)((float)(Math.atan2(ey - sy, ex - sx) * 180.0 / Math.PI)), (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_181662_b(0.0, -s, 0.0).func_187315_a(len / s / 2.0 + ms, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(0.0, s, 0.0).func_187315_a(len / s / 2.0 + ms, 1.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(len, s, 0.0).func_187315_a(ms, 1.0).func_181669_b(r * 3 / 4, g * 3 / 4, b * 3 / 4, a).func_181675_d();
                buffer.func_181662_b(len, -s, 0.0).func_187315_a(ms, 0.0).func_181669_b(r * 3 / 4, g * 3 / 4, b * 3 / 4, a).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
        if (this.treeGui.selectedChapter != null && this.isMouseOver()) {
            double dx = this.questMaxX - this.questMinX;
            double dy = this.questMaxY - this.questMinY;
            double px = (double)this.getX() - this.getScrollX();
            double py = (double)this.getY() - this.getScrollY();
            double qx = ((double)this.treeGui.getMouseX() - px) / this.treeGui.scrollWidth * dx + this.questMinX;
            double qy = ((double)this.treeGui.getMouseY() - py) / this.treeGui.scrollHeight * dy + this.questMinY;
            this.centerQuestX = ((double)this.treeGui.width / 2.0 - px) / this.treeGui.scrollWidth * dx + this.questMinX;
            this.centerQuestY = ((double)this.treeGui.height / 2.0 - py) / this.treeGui.scrollHeight * dy + this.questMinY;
            if (PanelQuests.isShiftKeyDown()) {
                this.questX = qx;
                this.questY = qy;
            } else {
                this.questX = (double)MathHelper.func_76128_c((double)(qx * 2.0 + 0.5)) / 2.0;
                this.questY = (double)MathHelper.func_76128_c((double)(qy * 2.0 + 0.5)) / 2.0;
            }
            if (this.treeGui.file.canEdit()) {
                theme.pushFontUnicode(true);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)1000.0);
                theme.drawString("X:" + (this.questX < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.questX), x + 3, y + h - 18, 2);
                theme.drawString("Y:" + (this.questY < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.questY), x + 3, y + h - 10, 2);
                theme.drawString("CX:" + (this.centerQuestX < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.centerQuestX), x + w - 30, y + h - 18, 2);
                theme.drawString("CY:" + (this.centerQuestY < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.centerQuestY), x + w - 30, y + h - 10, 2);
                GlStateManager.func_179121_F();
                theme.popFontUnicode();
                if (this.treeGui.movingObjects && !this.treeGui.selectedObjects.isEmpty()) {
                    double bs = this.treeGui.getQuestButtonSize();
                    double ominX = Double.POSITIVE_INFINITY;
                    double ominY = Double.POSITIVE_INFINITY;
                    double omaxX = Double.NEGATIVE_INFINITY;
                    double omaxY = Double.NEGATIVE_INFINITY;
                    for (Movable q : this.treeGui.selectedObjects) {
                        ominX = Math.min(ominX, q.getX());
                        ominY = Math.min(ominY, q.getY());
                        omaxX = Math.max(omaxX, q.getX());
                        omaxY = Math.max(omaxY, q.getY());
                    }
                    for (Movable m : this.treeGui.selectedObjects) {
                        double ox = m.getX() - ominX;
                        double oy = m.getY() - ominY;
                        double sx = (this.questX + ox - this.questMinX) / dx * this.treeGui.scrollWidth + px;
                        double sy = (this.questY + oy - this.questMinY) / dy * this.treeGui.scrollHeight + py;
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179137_b((double)(sx - bs * m.getWidth() / 2.0), (double)(sy - bs * m.getHeight() / 2.0), (double)0.0);
                        GlStateManager.func_179139_a((double)(bs * m.getWidth()), (double)(bs * m.getHeight()), (double)1.0);
                        GuiHelper.setupDrawing();
                        m.getShape().shape.withColor(Color4I.WHITE.withAlpha(30)).draw(0, 0, 1, 1);
                        GlStateManager.func_179121_F();
                    }
                    if (GuiQuestTree.grid && this.treeGui.viewQuestPanel.quest == null) {
                        double boxX = ominX / dx * this.treeGui.scrollWidth + px;
                        double boxY = ominY / dy * this.treeGui.scrollHeight + py;
                        double boxW = omaxX / dx * this.treeGui.scrollWidth + px - boxX;
                        double boxH = omaxY / dy * this.treeGui.scrollHeight + py - boxY;
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
                        GuiHelper.drawHollowRect((int)((int)boxX), (int)((int)boxY), (int)((int)boxW), (int)((int)boxH), (Color4I)Color4I.WHITE.withAlpha(30), (boolean)false);
                        GlStateManager.func_179121_F();
                    }
                } else {
                    int z = this.treeGui.getZoom();
                    double bs = this.treeGui.getQuestButtonSize();
                    double sx = (this.questX - this.questMinX) / dx * this.treeGui.scrollWidth + px;
                    double sy = (this.questY - this.questMinY) / dy * this.treeGui.scrollHeight + py;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(sx - bs / 2.0), (double)(sy - bs / 2.0), (double)0.0);
                    GlStateManager.func_179139_a((double)bs, (double)bs, (double)1.0);
                    GuiHelper.setupDrawing();
                    this.treeGui.selectedChapter.getDefaultQuestShape().shape.withColor(Color4I.WHITE.withAlpha(10)).draw(0, 0, 1, 1);
                    GlStateManager.func_179121_F();
                    if (GuiQuestTree.grid && this.treeGui.viewQuestPanel.quest == null) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
                        Color4I.WHITE.draw((int)sx, (int)sy, 1, 1);
                        Color4I.WHITE.withAlpha(30).draw(this.getX(), (int)sy, this.width, 1);
                        Color4I.WHITE.withAlpha(30).draw((int)sx, this.getY(), 1, this.height);
                        GlStateManager.func_179121_F();
                    }
                }
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (this.treeGui.selectedChapter == null) {
            return false;
        }
        if (this.treeGui.movingObjects && this.treeGui.file.canEdit()) {
            if (this.treeGui.selectedChapter != null && !button.isRight() && !this.treeGui.selectedObjects.isEmpty()) {
                GuiHelper.playClickSound();
                double minX = Double.POSITIVE_INFINITY;
                double minY = Double.POSITIVE_INFINITY;
                for (Movable q : this.treeGui.selectedObjects) {
                    minX = Math.min(minX, q.getX());
                    minY = Math.min(minY, q.getY());
                }
                for (Movable q : this.treeGui.selectedObjects) {
                    q.move(this.treeGui.selectedChapter, this.questX + (q.getX() - minX), this.questY + (q.getY() - minY));
                }
            }
            this.treeGui.movingObjects = false;
            this.treeGui.selectedObjects.clear();
            return true;
        }
        if (super.mousePressed(button)) {
            return true;
        }
        if (!this.treeGui.viewQuestPanel.hidePanel && this.treeGui.getViewedQuest() != null) {
            this.treeGui.closeQuest();
            return true;
        }
        if (button.isLeft() && this.isMouseOver() && (this.treeGui.viewQuestPanel.hidePanel || this.treeGui.getViewedQuest() == null)) {
            this.treeGui.prevMouseX = this.getMouseX();
            this.treeGui.prevMouseY = this.getMouseY();
            this.treeGui.grabbed = 1;
            return true;
        }
        if (button.isRight() && this.treeGui.file.canEdit()) {
            GuiHelper.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            double qx = this.questX;
            double qy = this.questY;
            for (TaskType type : TaskType.getRegistry()) {
                contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                    GuiHelper.playClickSound();
                    type.getGuiProvider().openCreationGui((IOpenableGui)this, new Quest(this.treeGui.selectedChapter), task -> new MessageCreateTaskAt(this.treeGui.selectedChapter, qx, qy, (Task)task).sendToServer());
                }));
            }
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.chapter.image", (Object[])new Object[0]), GuiIcons.ART, () -> {
                GuiHelper.playClickSound();
                ChapterImage image = new ChapterImage(this.treeGui.selectedChapter);
                image.x = qx;
                image.y = qy;
                this.treeGui.selectedChapter.images.add(image);
                new MessageEditObject(this.treeGui.selectedChapter).sendToServer();
            }));
            this.treeGui.openContextMenu(contextMenu);
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        this.treeGui.grabbed = 0;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (!this.treeGui.chapterHoverPanel.widgets.isEmpty()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        this.mouseOverQuest = null;
        super.updateMouseOver(mouseX, mouseY);
        for (Widget widget : this.widgets) {
            if (!widget.isMouseOver() || !(widget instanceof ButtonQuest)) continue;
            this.mouseOverQuest = (ButtonQuest)widget;
            break;
        }
    }

    public boolean scrollPanel(int scroll) {
        if (this.treeGui.selectedChapter != null && this.treeGui.getViewedQuest() == null && this.isMouseOver()) {
            this.treeGui.addZoom(scroll);
            return true;
        }
        return false;
    }
}

