/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfigValue;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiSelectFluid;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiSelectItemStack;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.FTBQuestsCommon;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.QuestFileCacheReloader;
import com.feed_the_beast.ftbquests.net.MessageSetCustomIcon;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.ItemReward;
import com.feed_the_beast.ftbquests.quest.reward.XPLevelsReward;
import com.feed_the_beast.ftbquests.quest.reward.XPReward;
import com.feed_the_beast.ftbquests.quest.task.DimensionTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.FluidTask;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import com.feed_the_beast.ftbquests.quest.task.LocationTask;
import com.feed_the_beast.ftbquests.quest.theme.ThemeLoader;
import com.latmod.mods.itemfilters.filters.NBTMatchingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FTBQuestsClient
extends FTBQuestsCommon {
    private static final Pattern I18N_PATTERN = Pattern.compile("\\{([a-zA-Z0-9\\._\\-]*?)\\}", 8);
    public static KeyBinding KEY_QUESTS;

    public static String addI18nAndColors(String text) {
        if (text.isEmpty()) {
            return text;
        }
        Matcher i18nMatcher = I18N_PATTERN.matcher(text);
        while (i18nMatcher.find()) {
            i18nMatcher.reset();
            StringBuffer sb = new StringBuffer(text.length());
            while (i18nMatcher.find()) {
                i18nMatcher.appendReplacement(sb, I18n.func_135052_a((String)i18nMatcher.group(1), (Object[])new Object[0]));
            }
            i18nMatcher.appendTail(sb);
            text = sb.toString();
            i18nMatcher = I18N_PATTERN.matcher(text);
        }
        if (StringUtils.unformatted((String)(text = StringUtils.addFormatting((String)text.trim()))).isEmpty()) {
            return "";
        }
        return text;
    }

    @Override
    public void preInit() {
        KEY_QUESTS = new KeyBinding("key.ftbquests.quests", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 0, "key.categories.ftbmods");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_QUESTS);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new QuestFileCacheReloader());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new ThemeLoader());
    }

    @Override
    @Nullable
    public QuestFile getQuestFile(@Nullable World world) {
        return this.getQuestFile(world == null ? FMLCommonHandler.instance().getEffectiveSide().isClient() : world.field_72995_K);
    }

    @Override
    @Nullable
    public QuestFile getQuestFile(boolean clientSide) {
        return clientSide ? ClientQuestFile.INSTANCE : ServerQuestFile.INSTANCE;
    }

    @Override
    public void setTaskGuiProviders() {
        FTBQuestsTasks.ITEM.setGuiProvider((gui, quest, callback) -> new GuiSelectItemStack(gui, stack -> {
            if (!stack.func_190926_b()) {
                ItemTask itemTask = new ItemTask(quest);
                itemTask.items.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                itemTask.count = stack.func_190916_E();
                if (!stack.func_77985_e()) {
                    itemTask.nbtMode = NBTMatchingMode.IGNORE;
                    itemTask.ignoreDamage = !stack.func_77981_g();
                }
                callback.accept(itemTask);
            }
        }).openGui());
        FTBQuestsTasks.FLUID.setGuiProvider((gui, quest, callback) -> new GuiSelectFluid(gui, () -> FluidRegistry.WATER, fluid -> {
            if (fluid != null) {
                FluidTask fluidTask = new FluidTask(quest);
                fluidTask.fluid = fluid;
                callback.accept(fluidTask);
            }
        }).openGui());
        FTBQuestsTasks.DIMENSION.setGuiProvider((gui, quest, callback) -> {
            DimensionTask task = new DimensionTask(quest);
            task.dimension = Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
            callback.accept(task);
        });
        FTBQuestsTasks.LOCATION.setGuiProvider((gui, quest, callback) -> {
            TileEntity tileEntity;
            LocationTask task = new LocationTask(quest);
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && (tileEntity = mc.field_71441_e.func_175625_s(mc.field_71476_x.func_178782_a())) instanceof TileEntityStructure) {
                BlockPos pos = ((TileEntityStructure)tileEntity).func_189711_e();
                BlockPos size = ((TileEntityStructure)tileEntity).func_189717_g();
                task.dimension = mc.field_71441_e.field_73011_w.getDimension();
                task.x = pos.func_177958_n() + tileEntity.func_174877_v().func_177958_n();
                task.y = pos.func_177956_o() + tileEntity.func_174877_v().func_177956_o();
                task.z = pos.func_177952_p() + tileEntity.func_174877_v().func_177952_p();
                task.w = Math.max(1, size.func_177958_n());
                task.h = Math.max(1, size.func_177956_o());
                task.d = Math.max(1, size.func_177952_p());
                callback.accept(task);
                return;
            }
            ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
            task.getConfig(task.createSubGroup(group));
            new GuiEditConfig(group, (g1, sender) -> callback.accept(task)).openGui();
        });
    }

    @Override
    public void setRewardGuiProviders() {
        FTBQuestsRewards.ITEM.setGuiProvider((gui, quest, callback) -> new GuiSelectItemStack(gui, stack -> {
            if (!stack.func_190926_b()) {
                callback.accept(new ItemReward(quest, (ItemStack)stack));
            }
        }).openGui());
        FTBQuestsRewards.XP.setGuiProvider((gui, quest, callback) -> new GuiEditConfigValue("xp", (ConfigValue)new ConfigInt(100, 1, Integer.MAX_VALUE), (value, set) -> {
            gui.openGui();
            if (set) {
                XPReward reward = new XPReward(quest);
                reward.xp = value.getInt();
                callback.accept(reward);
            }
        }).openGui());
        FTBQuestsRewards.XP_LEVELS.setGuiProvider((gui, quest, callback) -> new GuiEditConfigValue("xp_levels", (ConfigValue)new ConfigInt(1, 1, Integer.MAX_VALUE), (value, set) -> {
            gui.openGui();
            if (set) {
                XPLevelsReward reward = new XPLevelsReward(quest);
                reward.xpLevels = value.getInt();
                callback.accept(reward);
            }
        }).openGui());
    }

    @Override
    public String getLanguageCode() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
    }

    @Override
    public void openCustomIconGui(ItemStack stack) {
        new GuiEditConfigValue("icon", (ConfigValue)new ConfigString(stack.func_77942_o() ? stack.func_77978_p().func_74779_i("icon") : ""), (value, set) -> {
            if (set) {
                stack.func_77983_a("icon", (NBTBase)new NBTTagString(value.getString()));
                new MessageSetCustomIcon(value.getString()).sendToServer();
            }
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }).openGui();
    }
}

