/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.api.block.ICarvable;
import team.chisel.api.block.VariationData;
import team.chisel.client.util.ClientUtil;
import team.chisel.common.init.ChiselTabs;
import team.chisel.common.util.PropertyAnyInteger;

@ParametersAreNonnullByDefault
public class BlockCarvablePane
extends BlockPane
implements ICarvable {
    private final BlockRenderLayer layer;
    public final PropertyAnyInteger metaProp;
    private final VariationData[] variations;
    private int index;
    private final int maxVariation;
    private final BlockStateContainer states;
    private boolean dragonProof = false;

    public static BlockCarvablePane cutout(Material material, int index, int max, VariationData ... variations) {
        return new BlockCarvablePane(material, BlockRenderLayer.CUTOUT_MIPPED, true, index, max, variations);
    }

    public static BlockCarvablePane cutoutNoDrop(Material material, int index, int max, VariationData ... variations) {
        return new BlockCarvablePane(material, BlockRenderLayer.CUTOUT_MIPPED, false, index, max, variations);
    }

    public static BlockCarvablePane translucentNoDrop(Material material, int index, int max, VariationData ... variations) {
        return new BlockCarvablePane(material, BlockRenderLayer.TRANSLUCENT, false, index, max, variations);
    }

    public BlockCarvablePane(Material material, BlockRenderLayer layer, boolean canDrop, int index, int max, VariationData ... variations) {
        super(material, canDrop);
        this.func_149647_a(ChiselTabs.tab);
        this.layer = layer;
        this.index = index;
        this.variations = variations;
        this.maxVariation = max;
        this.metaProp = PropertyAnyInteger.create("variation", 0, max > index * 16 ? 15 : max % 16);
        this.states = new BlockStateContainer((Block)this, new IProperty[]{field_176241_b, field_176242_M, field_176244_O, field_176243_N, this.metaProp});
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    public BlockStateContainer func_176194_O() {
        return this.states;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        this.field_149783_u = true;
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.metaProp, (Comparable)Integer.valueOf(this.clampMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.metaProp);
    }

    public String getIndexName() {
        if (this.index == 0) {
            return this.func_149739_a();
        }
        return this.func_149739_a() + this.index;
    }

    public static BlockPos pos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        int curIndex = 0;
        for (VariationData var : this.variations) {
            if (var == null) continue;
            ItemStack stack = new ItemStack((Block)this, 1, curIndex);
            ++curIndex;
            list.add((Object)stack);
        }
    }

    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager effectRenderer) {
        ClientUtil.addHitEffects(worldObj, target.func_178782_a(), target.field_178784_b);
        return true;
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        ClientUtil.addDestroyEffects(world, pos, world.func_180495_p(pos));
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    @Override
    public int getVariationIndex(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public int getTotalVariations() {
        return this.maxVariation + 1;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    private int clampMeta(int meta) {
        return MathHelper.func_76125_a((int)meta, (int)0, (int)(this.variations.length - 1));
    }

    @Override
    public VariationData getVariationData(int meta) {
        return this.variations[this.clampMeta(meta)];
    }

    public Block setDragonProof() {
        this.dragonProof = true;
        return this;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityDragon) {
            return !this.dragonProof;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!super.func_176225_a(blockState, blockAccess, pos, side)) {
            if (side.func_176740_k() != EnumFacing.Axis.Y) {
                return false;
            }
            return blockAccess.func_180495_p(pos.func_177972_a(side)).func_185899_b(blockAccess, pos.func_177972_a(side)) != blockState;
        }
        return true;
    }

    public PropertyAnyInteger getMetaProp() {
        return this.metaProp;
    }

    @Override
    public VariationData[] getVariations() {
        return this.variations;
    }
}

