/*
 * Decompiled with CFR 0.152.
 */
package jeresources.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jeresources.entry.DungeonEntry;
import jeresources.util.TranslationHelper;

public class DungeonRegistry {
    private Map<String, DungeonEntry> registry = new LinkedHashMap<String, DungeonEntry>();
    public static Map<String, String> categoryToLocalKeyMap = new LinkedHashMap<String, String>();
    private static DungeonRegistry instance;

    public static DungeonRegistry getInstance() {
        if (instance == null) {
            instance = new DungeonRegistry();
            return instance;
        }
        return instance;
    }

    public DungeonRegistry() {
        DungeonRegistry.addCategoryMapping("chests/abandoned_mineshaft", "jer.dungeon.abandonedMineshaftChest");
        DungeonRegistry.addCategoryMapping("chests/desert_pyramid", "jer.dungeon.desertPyramidChest");
        DungeonRegistry.addCategoryMapping("chests/jungle_temple", "jer.dungeon.pyramidJungleChest");
        DungeonRegistry.addCategoryMapping("chests/igloo_chest", "jer.dungeon.iglooChest");
        DungeonRegistry.addCategoryMapping("chests/stronghold_corridor", "jer.dungeon.strongholdCorridorChest");
        DungeonRegistry.addCategoryMapping("chests/stronghold_library", "jer.dungeon.strongholdLibraryChest");
        DungeonRegistry.addCategoryMapping("chests/stronghold_crossing", "jer.dungeon.strongholdCrossingChest");
        DungeonRegistry.addCategoryMapping("chests/village_blacksmith", "jer.dungeon.villageBlacksmithChest");
        DungeonRegistry.addCategoryMapping("chests/spawn_bonus_chest", "jer.dungeon.spawnBonusChest");
        DungeonRegistry.addCategoryMapping("chests/simple_dungeon", "jer.dungeon.simpleDungeonChest");
        DungeonRegistry.addCategoryMapping("chests/nether_bridge", "jer.dungeon.netherBridgeChest");
        DungeonRegistry.addCategoryMapping("chests/end_city_treasure", "jer.dungeon.endCityTreasureChest");
        DungeonRegistry.addCategoryMapping("chests/woodland_mansion", "jer.dungeon.woodlandMansion");
    }

    public static boolean addCategoryMapping(String category, String name) {
        if (!categoryToLocalKeyMap.containsKey(category)) {
            categoryToLocalKeyMap.put(category, name);
            return true;
        }
        return false;
    }

    public void registerDungeonEntry(DungeonEntry entry) {
        if (entry == null) {
            return;
        }
        String name = entry.getName();
        if (this.registry.containsKey(name)) {
            return;
        }
        this.registry.put(name, entry);
    }

    public List<DungeonEntry> getDungeons() {
        return new ArrayList<DungeonEntry>(this.registry.values());
    }

    public String getNumStacks(DungeonEntry entry) {
        int max = entry.getMaxStacks();
        int min = entry.getMinStacks();
        if (min == max) {
            return String.format(TranslationHelper.translateToLocal("jer.stacks"), max);
        }
        return String.format(TranslationHelper.translateToLocal("jer.stacks"), min + " - " + max);
    }

    public void clear() {
        this.registry.clear();
    }
}

