/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.docmanagement;

import codechicken.lib.reflect.ObfMapping;
import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.integration.ModHelperBC;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.gui.GuiProjectIntelligence;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.docmanagement.ContentRelation;
import com.brandon3055.projectintelligence.docmanagement.DocumentationPage;
import com.brandon3055.projectintelligence.docmanagement.LanguageManager;
import com.brandon3055.projectintelligence.docmanagement.ModStructurePage;
import com.brandon3055.projectintelligence.docmanagement.PIUpdateManager;
import com.brandon3055.projectintelligence.docmanagement.RootPage;
import com.brandon3055.projectintelligence.utils.LogHelper;
import com.google.common.primitives.Ints;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;

public class DocumentationManager {
    public static File piConfigDirectory;
    private static File docDirectoryCache;
    private static File packDocDirectoryCache;
    private static RootPage rootPage;
    private static Map<String, DocumentationPage> uriPageMap;
    private static Map<String, ModStructurePage> modStructureMap;
    private static Map<ModStructurePage, File> structureFileMap;
    private static Map<String, Map<String, File>> installedModVersionFileMap;
    public static Map<String, LinkedList<String>> sortedModVersionMap;
    private static Map<String, String> activeModVersionMap;
    private static Map<String, File> packDocFileMap;
    private static Map<ContentRelation.Type, Map<ContentRelation, DocumentationPage>> contentRelationsMap;
    public static Comparator<String> VERSION_COMPARATOR;

    public static void initialize() {
        piConfigDirectory = new File(FileHandler.brandon3055Folder, "ProjectIntelligence");
        if (!piConfigDirectory.exists() && !piConfigDirectory.mkdirs()) {
            LogHelper.bigError("Failed to create config directory! Things are going to break! " + piConfigDirectory, new Object[0]);
        }
        ModContainer piContainer = (ModContainer)Loader.instance().getIndexedModList().get("projectintelligence");
        CraftingHelper.findFiles((ModContainer)piContainer, (String)"assets/projectintelligence/default_styles", path -> true, (path2, filePath) -> {
            if (filePath.toString().endsWith(".json")) {
                try {
                    Path styleFolder = Paths.get(piConfigDirectory.getAbsolutePath(), "GuiStyle/DefaultPresets");
                    if (!Files.exists(styleFolder, new LinkOption[0])) {
                        Files.createDirectories(styleFolder, new FileAttribute[0]);
                    }
                    Path outputFile = styleFolder.resolve(filePath.getFileName().toString());
                    Files.copy(filePath, outputFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }, (boolean)false, (boolean)false);
        DocumentationManager.checkAndReloadDocFiles();
    }

    public static void checkAndReloadDocFiles() {
        DocumentationManager.clearDocDirCache();
        DocumentationManager.getDocDirectory();
        if (PIConfig.editMode()) {
            DocumentationManager.loadDocumentationFromDisk();
            return;
        }
        PIUpdateManager.performFullUpdateCheck();
    }

    public static void loadDocumentationFromDisk() {
        LogHelper.dev("");
        LogHelper.dev("### Reloading mod documentation from disk... ###");
        DocumentationManager.clearDocDirCache();
        modStructureMap.clear();
        uriPageMap.clear();
        structureFileMap.clear();
        installedModVersionFileMap.clear();
        contentRelationsMap.clear();
        LanguageManager.clearTranslations();
        File docDir = DocumentationManager.getDocDirectory();
        ArrayList modFolders = new ArrayList();
        DocumentationManager.parseFilesInDirectory(docDir, File::isDirectory, modFolders::add);
        LogHelper.dev("Found " + modFolders.size() + " potential mod root folders.");
        for (File modFolder : modFolders) {
            LogHelper.dev("Checking potential mod folder: " + modFolder);
            ArrayList modVersionFolders = new ArrayList();
            DocumentationManager.parseFilesInDirectory(modFolder, File::isDirectory, modVersionFolders::add);
            LogHelper.dev("Found " + modVersionFolders.size() + " potential document version folders.");
            for (File verFolder : modVersionFolders) {
                LogHelper.dev("Checking potential version folder: " + verFolder);
                File structure = new File(verFolder, "structure/structure.json");
                if (structure.exists()) {
                    LogHelper.dev("Found structure file! Structure file will be parsed and added to version list.");
                    DocumentationManager.parseStructureFile(structure, verFolder, false);
                    continue;
                }
                LogHelper.dev("No structure file found. This is not a valid version folder.");
            }
        }
        File packDocDir = DocumentationManager.getPackDocDirectory();
        ArrayList packFolders = new ArrayList();
        DocumentationManager.parseFilesInDirectory(packDocDir, File::isDirectory, packFolders::add);
        LogHelper.dev("");
        LogHelper.dev("Found " + packFolders.size() + " potential pack documentation folders.");
        for (File docFolder : packFolders) {
            LogHelper.dev("Checking potential pack documentation folder: " + docFolder);
            File structure = new File(docFolder, "structure/structure.json");
            if (structure.exists()) {
                LogHelper.dev("Found structure file! Structure file will be parsed and added to pack doc list.");
                DocumentationManager.parseStructureFile(structure, docFolder, true);
                continue;
            }
            LogHelper.dev("No structure file found. This is not a valid pack doc folder.");
        }
        LogHelper.dev("");
        DocumentationManager.sortDocVersions();
        DocumentationManager.loadRootPage();
        LogHelper.startTimer("LanguageManager.reloadLookupMap");
        LanguageManager.reloadLookupMap();
        LogHelper.stopTimer();
        GuiProjectIntelligence.requiresEditReload = true;
        if (PIGuiHelper.editor != null) {
            PIGuiHelper.editor.reload();
        }
    }

    private static void loadRootPage() {
        rootPage = new RootPage();
        DataUtils.forEachMatch(modStructureMap.values(), DocumentationPage::isPackDoc, rootPage::addModPage);
        DataUtils.forEachMatch(modStructureMap.values(), page -> !page.isPackDoc(), rootPage::addModPage);
    }

    private static void parseStructureFile(File structureFile, File versionFolder, boolean isPackDoc) {
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(structureFile), StandardCharsets.UTF_8));){
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse(jsonReader);
            if (element.isJsonObject()) {
                JsonObject jObj = element.getAsJsonObject();
                ModStructurePage structurePage = ModStructurePage.generateFromJson(jObj, isPackDoc);
                if (structurePage == null) {
                    PIGuiHelper.displayError("Found invalid doc structure file: " + structureFile + " No modid or lang detected.");
                    return;
                }
                if (isPackDoc) {
                    packDocFileMap.put(structurePage.modid, versionFolder);
                    return;
                }
                if (!versionFolder.getParentFile().getName().equals(structurePage.getModid())) {
                    PIGuiHelper.displayError("Found a mod documentation structure file in the wrong rood mod folder!\n\nThe name of the mod folder must match the mod's mod id!\n\nFound file for modid: " + structurePage.modid + " In folder:" + versionFolder.getParentFile());
                    return;
                }
                if (!versionFolder.getName().equals(structurePage.modVersion)) {
                    PIGuiHelper.displayError("Found a mod documentation structure file in the wrong version folder!\n\nThe name of the version folder must match the version!\n\nFound file for version: " + structurePage.modVersion + " In folder:" + versionFolder);
                    return;
                }
                installedModVersionFileMap.computeIfAbsent(structurePage.getModid(), s -> new HashMap()).put(structurePage.modVersion, versionFolder);
            }
        }
        catch (Exception e) {
            PIGuiHelper.displayError("Error reading mod descriptor file: " + e.getMessage() + "\n\nError occurred while reading file: " + structureFile);
            LogHelper.error("Error reading mod descriptor file");
            e.printStackTrace();
        }
    }

    public static void saveDocToDisk(ModStructurePage modPage) {
        if (!PIConfig.editMode()) {
            PIGuiHelper.displayError("Can not save documentation when not in edit mode!");
            return;
        }
        if (!structureFileMap.containsKey(modPage)) {
            PIGuiHelper.displayError("Something went wrong... Attempted to save mod descriptor but could not find cached save file");
            return;
        }
        JsonObject jObj = modPage.writeToJson();
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriterWithEncoding(structureFileMap.get(modPage), StandardCharsets.UTF_8));){
            writer.setIndent("  ");
            Streams.write((JsonElement)jObj, (JsonWriter)writer);
            writer.flush();
        }
        catch (Exception e) {
            PIGuiHelper.displayError("Error saving mod Descriptor " + e.getMessage());
            LogHelper.error("Error saving mod Descriptor");
            e.printStackTrace();
        }
    }

    public static void parseFilesInDirectory(File directory, Predicate<File> fileValidator, Consumer<File> fileProcessor) {
        if (!directory.exists() || !directory.isDirectory()) {
            PIGuiHelper.displayError("An error occurred while parsing documentation files.\nThe pacified file does not exist or is not a directory: " + directory);
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            PIGuiHelper.displayError("An error occurred while parsing documentation files.\nAn error occurred while trying to read files ib the following directory: " + directory);
            return;
        }
        for (File file : files) {
            if (!fileValidator.test(file)) continue;
            fileProcessor.accept(file);
        }
    }

    private static void sortDocVersions() {
        LogHelper.startTimer("Sorting documentation versions");
        LogHelper.dev("Sorting documentation versions...");
        activeModVersionMap.clear();
        sortedModVersionMap.clear();
        for (String modid : installedModVersionFileMap.keySet()) {
            Map<String, File> versionFolderMap = installedModVersionFileMap.get(modid);
            LinkedList<String> versions = new LinkedList<String>(versionFolderMap.keySet());
            versions.sort(VERSION_COMPARATOR);
            sortedModVersionMap.put(modid, versions);
            String versionOverride = PIConfig.modVersionOverrides.get(modid);
            if (versionOverride != null && versionFolderMap.containsKey(versionOverride)) {
                if (DocumentationManager.loadDocVersion(versionFolderMap.get(versionOverride), false)) {
                    LogHelper.dev("Version override enabled for mod: " + modid + " version " + versionOverride + " will be loaded");
                    activeModVersionMap.put(modid, versionOverride);
                    continue;
                }
            } else if (versionOverride != null) {
                PIConfig.modVersionOverrides.remove(modid);
                PIConfig.save();
            }
            String installedVersion = ModHelperBC.getModVersion((String)modid);
            LogHelper.dev("Checking Mod: " + modid + " Installed: " + installedVersion);
            boolean versionLoaded = false;
            if (installedVersion != null) {
                String version;
                Iterator<String> i = versions.descendingIterator();
                while (i.hasNext()) {
                    version = i.next();
                    if (DocumentationManager.compareVersion(installedVersion, version) < 0) continue;
                    LogHelper.dev("Found best version match for mod: " + modid + " loading version " + version);
                    DocumentationManager.loadDocVersion(versionFolderMap.get(version), false);
                    versionLoaded = true;
                    break;
                }
                if (!versionLoaded && !ObfMapping.obfuscated) {
                    version = versions.getLast();
                    LogHelper.dev("No version match found for " + modid + " but mod is running in dev so loading the latest version: " + version);
                    DocumentationManager.loadDocVersion(versionFolderMap.get(version), false);
                }
            }
            if (versionLoaded || !PIConfig.editMode()) continue;
            LogHelper.dev("Mod " + modid + " is not installed or its version is not supporter but edit mode is enabled. Loading latest version: " + versions.getLast());
            DocumentationManager.loadDocVersion(versionFolderMap.get(versions.getLast()), false);
        }
        for (String pack : packDocFileMap.keySet()) {
            DocumentationManager.loadDocVersion(packDocFileMap.get(pack), true);
        }
        LogHelper.stopTimer();
    }

    public static int compareVersion(String version1, String version2) {
        if (version2 == null || version2.equals(version1)) {
            return 0;
        }
        int[] v1 = DocumentationManager.stringToInt(version1.split("\\."));
        int[] v2 = DocumentationManager.stringToInt(version2.split("\\."));
        return Ints.lexicographicalComparator().compare(v1, v2);
    }

    public static int[] stringToInt(String[] strings) {
        int[] ints = new int[strings.length];
        for (int i = 0; i < ints.length; ++i) {
            Integer v = Ints.tryParse((String)strings[i]);
            ints[i] = v == null ? 0 : v;
        }
        return ints;
    }

    private static boolean loadDocVersion(File versionFolder, boolean isPackDock) {
        LogHelper.dev("Loading Documentation from: " + versionFolder);
        File structureFile = new File(versionFolder, "structure/structure.json");
        try {
            JsonParser parser = new JsonParser();
            JsonReader jsonReader = new JsonReader((Reader)new FileReader(structureFile));
            JsonElement element = parser.parse(jsonReader);
            IOUtils.closeQuietly((Closeable)jsonReader);
            if (element.isJsonObject()) {
                JsonObject jObj = element.getAsJsonObject();
                ModStructurePage structurePage = ModStructurePage.generateFromJson(jObj, isPackDock);
                if (structurePage == null) {
                    PIGuiHelper.displayError("Found invalid mod structure file. No modid or lang detected.");
                    return false;
                }
                uriPageMap.putAll(structurePage.getURIPageMap());
                modStructureMap.put(structurePage.getModid(), structurePage);
                structureFileMap.put(structurePage, structureFile);
                LanguageManager.loadModLocalization(structurePage.getModid(), structureFile.getParentFile());
                return true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void addNewDocVersion(String modid, String newVersion, @Nullable String copyFrom) throws IOException {
        Map<String, File> versionFileMap = installedModVersionFileMap.get(modid);
        ModStructurePage existingPage = DocumentationManager.getModPage(modid);
        if (versionFileMap == null || versionFileMap.containsKey(newVersion) || existingPage == null) {
            return;
        }
        File modFolder = new File(DocumentationManager.getDocDirectory(), modid + "/" + newVersion + "/structure");
        if (!modFolder.exists() && !modFolder.mkdirs()) {
            throw new IOException("Failed to create mod directory! " + modFolder);
        }
        File structure = new File(modFolder, "structure.json");
        if (structure.exists()) {
            throw new IOException("Mod structure file already exists! Perhaps it is invalid? Structure file:" + structure);
        }
        if (copyFrom == null) {
            ModStructurePage modPage = new ModStructurePage(null, modid, newVersion, false);
            structureFileMap.put(modPage, structure);
            modStructureMap.put(modid, modPage);
            DocumentationManager.saveDocToDisk(modPage);
            LanguageManager.setPageName(modid, modid + ":", existingPage.getModPageName(), LanguageManager.getUserLanguage());
        } else {
            if (!versionFileMap.containsKey(copyFrom)) {
                throw new IOException("It seems the version you are trying to copy does not exist?!?!?");
            }
            File copyFromVersion = versionFileMap.get(copyFrom);
            File newVersionFolder = new File(DocumentationManager.getDocDirectory(), modid + "/" + newVersion);
            FileUtils.copyDirectory((File)copyFromVersion, (File)newVersionFolder);
            if (!structure.exists()) {
                throw new IOException("Attempted to copy version but could not find copied structure file. " + structure);
            }
            try {
                ModStructurePage structurePage;
                JsonParser parser = new JsonParser();
                JsonReader jsonReader = new JsonReader((Reader)new FileReader(structure));
                JsonElement element = parser.parse(jsonReader);
                IOUtils.closeQuietly((Closeable)jsonReader);
                if (element.isJsonObject()) {
                    JsonObject jObj = element.getAsJsonObject();
                    structurePage = ModStructurePage.generateFromJson(jObj, false);
                    if (structurePage == null) {
                        throw new IOException("Error reading copied structure file. " + structure);
                    }
                } else {
                    throw new IOException("Error reading copied structure file. (File is not a valid json)" + structure);
                }
                structurePage.modVersion = newVersion;
                LogHelper.dev("NewVersion: " + newVersion);
                structureFileMap.put(structurePage, structure);
                modStructureMap.put(modid, structurePage);
                DocumentationManager.saveDocToDisk(structurePage);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        DocumentationManager.checkAndReloadDocFiles();
    }

    public static void clearDocDirCache() {
        docDirectoryCache = null;
        packDocDirectoryCache = null;
    }

    public static File getDocDirectory() {
        if (docDirectoryCache != null) {
            return docDirectoryCache;
        }
        if (PIConfig.editMode()) {
            File file = new File(PIConfig.editingRepoLoc);
            if (file.exists() && file.isDirectory()) {
                docDirectoryCache = file;
                return docDirectoryCache;
            }
            PIConfig.setEditMode(false);
            PIConfig.save();
            PIGuiHelper.displayError("Specified editing directory does not exist or is not a directory! Edit mode disabled.");
            PIGuiHelper.displayError("Please clone or download the Project Intelligence documentation repo from https://github.com/brandon3055/Project-Intelligence-Docs then specify the location of the ModDocs repo.");
            PIGuiHelper.displayError("e.g. C:\\Users\\<your-name>\\Desktop\\Project-Intelligence-Docs\\ModDocs");
        }
        if (!(docDirectoryCache = new File(piConfigDirectory, "ModDocs")).exists() && !docDirectoryCache.mkdirs()) {
            LogHelper.bigError("Failed to create document directory! Things are going to break! " + docDirectoryCache, new Object[0]);
        }
        return docDirectoryCache;
    }

    public static File getDlDocDirectory() {
        File dir = new File(piConfigDirectory, "ModDocs");
        if (!dir.exists() && !dir.mkdirs()) {
            LogHelper.bigError("Failed to create document directory! Things are going to break! " + dir, new Object[0]);
        }
        return dir;
    }

    public static File getPackDocDirectory() {
        if (packDocDirectoryCache != null) {
            return packDocDirectoryCache;
        }
        packDocDirectoryCache = new File(piConfigDirectory, "PackDocs");
        if (!packDocDirectoryCache.exists() && !packDocDirectoryCache.mkdirs()) {
            LogHelper.bigError("Failed to create pack document directory! Things are going to break! " + packDocDirectoryCache, new Object[0]);
        }
        return packDocDirectoryCache;
    }

    public static boolean hasModPage(String modid) {
        return modStructureMap.containsKey(modid);
    }

    public static ModStructurePage getModPage(String modid) {
        return modStructureMap.get(modid);
    }

    public static boolean hasPage(String pagePath) {
        return uriPageMap.containsKey(pagePath);
    }

    @Nullable
    public static synchronized DocumentationPage getPage(@Nullable String pageURI) {
        return pageURI == null || pageURI.equals("[pi_root_page]") ? rootPage : uriPageMap.get(pageURI);
    }

    public static Collection<DocumentationPage> getAllPages() {
        return uriPageMap.values();
    }

    public static Collection<String> getAllPageURIs() {
        return uriPageMap.keySet();
    }

    public static synchronized Map<String, ModStructurePage> getModStructureMap() {
        return modStructureMap;
    }

    public static Collection<String> getDocumentedMods() {
        return installedModVersionFileMap.keySet();
    }

    public static void setModVersionOverride(String modid, @Nullable String version) {
        if (version == null) {
            PIConfig.modVersionOverrides.remove(modid);
        } else {
            List versions = sortedModVersionMap.get(modid);
            if (versions != null && versions.contains(version)) {
                PIConfig.modVersionOverrides.put(modid, version);
            } else {
                PIConfig.modVersionOverrides.remove(modid);
            }
        }
        PIConfig.save();
        DocumentationManager.checkAndReloadDocFiles();
    }

    public static void clear() {
        uriPageMap.clear();
        modStructureMap.clear();
        structureFileMap.clear();
        installedModVersionFileMap.clear();
        sortedModVersionMap.clear();
        activeModVersionMap.clear();
        packDocFileMap.clear();
        contentRelationsMap.clear();
        DocumentationManager.loadRootPage();
        LanguageManager.clearTranslations();
    }

    public static void clearRelationCache() {
        contentRelationsMap.clear();
    }

    private static void checkInitRelationMap() {
        if (contentRelationsMap.isEmpty()) {
            for (DocumentationPage page : uriPageMap.values()) {
                for (ContentRelation relation : page.relations) {
                    contentRelationsMap.computeIfAbsent(relation.type, type -> new HashMap()).put(relation, page);
                }
            }
        }
    }

    public static List<DocumentationPage> getRelatedPages(ItemStack stack) {
        DocumentationManager.checkInitRelationMap();
        ArrayList<DocumentationPage> results = new ArrayList<DocumentationPage>();
        Map<ContentRelation, DocumentationPage> candidates = contentRelationsMap.get((Object)ContentRelation.Type.STACK);
        if (candidates != null) {
            for (ContentRelation relation : candidates.keySet()) {
                DocumentationPage page = candidates.get(relation);
                if (!relation.isMatch(stack) || results.contains(page)) continue;
                results.add(page);
            }
        }
        return results;
    }

    public static List<DocumentationPage> getRelatedPages(Fluid stack) {
        DocumentationManager.checkInitRelationMap();
        ArrayList<DocumentationPage> results = new ArrayList<DocumentationPage>();
        Map<ContentRelation, DocumentationPage> candidates = contentRelationsMap.get((Object)ContentRelation.Type.FLUID);
        if (candidates != null) {
            for (ContentRelation relation : candidates.keySet()) {
                DocumentationPage page = candidates.get(relation);
                if (!relation.isMatch(stack) || results.contains(page)) continue;
                results.add(page);
            }
        }
        return results;
    }

    public static List<DocumentationPage> getRelatedPages(String entityRegName) {
        DocumentationManager.checkInitRelationMap();
        ArrayList<DocumentationPage> results = new ArrayList<DocumentationPage>();
        Map<ContentRelation, DocumentationPage> candidates = contentRelationsMap.get((Object)ContentRelation.Type.ENTITY);
        if (candidates != null) {
            for (ContentRelation relation : candidates.keySet()) {
                DocumentationPage page = candidates.get(relation);
                if (!relation.contentString.equals(entityRegName) || results.contains(page)) continue;
                results.add(page);
            }
        }
        return results;
    }

    public static void addMod(String modid, String modName, String version) throws IOException {
        if (!PIConfig.editMode()) {
            return;
        }
        ModStructurePage modPage = new ModStructurePage(null, modid, version, false);
        File modFolder = new File(DocumentationManager.getDocDirectory(), modid + "/" + version + "/structure");
        if (!modFolder.exists() && !modFolder.mkdirs()) {
            throw new IOException("Failed to create mod directory! " + modFolder);
        }
        File structure = new File(modFolder, "structure.json");
        if (structure.exists()) {
            throw new IOException("Mod structure file already exists! Perhaps it is invalid? Structure file:" + structure);
        }
        structureFileMap.put(modPage, structure);
        modStructureMap.put(modid, modPage);
        DocumentationManager.saveDocToDisk(modPage);
        LanguageManager.setPageName(modid, modid + ":", modName, LanguageManager.getUserLanguage());
        DocumentationManager.checkAndReloadDocFiles();
    }

    public static void addLocalDoc(String docID, String docName) throws IOException {
        if (!PIConfig.editMode()) {
            return;
        }
        ModStructurePage docPage = new ModStructurePage(null, docID, "", true);
        File docFolder = new File(DocumentationManager.getPackDocDirectory(), docID + "/structure");
        if (!docFolder.exists() && !docFolder.mkdirs()) {
            throw new IOException("Failed to create doc directory! " + docFolder);
        }
        File structure = new File(docFolder, "structure.json");
        if (structure.exists()) {
            throw new IOException("Mod structure file already exists! Perhaps it is invalid? Structure file:" + structure);
        }
        structureFileMap.put(docPage, structure);
        modStructureMap.put(docID, docPage);
        DocumentationManager.saveDocToDisk(docPage);
        LanguageManager.setPageName(docID, docID + ":", docName, LanguageManager.getUserLanguage());
        DocumentationManager.checkAndReloadDocFiles();
    }

    public static void deleteDoc(DocumentationPage page) {
        DocumentationManager.getDocDirectory();
        if (!PIConfig.editMode()) {
            return;
        }
        File docFolder = new File(page.isPackDoc() ? DocumentationManager.getPackDocDirectory() : DocumentationManager.getDocDirectory(), page.getModid());
        if (docFolder.exists() && docFolder.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)docFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (page instanceof ModStructurePage) {
            DocumentationManager.loadDocumentationFromDisk();
        } else {
            uriPageMap.remove(page.pageURI);
        }
    }

    public static boolean doesPageExist(String pageURI) {
        return pageURI.equals("[pi_root_page]") || uriPageMap.containsKey(pageURI);
    }

    static {
        docDirectoryCache = null;
        packDocDirectoryCache = null;
        rootPage = new RootPage();
        uriPageMap = Collections.synchronizedMap(new HashMap());
        modStructureMap = Collections.synchronizedMap(new HashMap());
        structureFileMap = Collections.synchronizedMap(new HashMap());
        installedModVersionFileMap = Collections.synchronizedMap(new HashMap());
        sortedModVersionMap = Collections.synchronizedMap(new HashMap());
        activeModVersionMap = Collections.synchronizedMap(new HashMap());
        packDocFileMap = Collections.synchronizedMap(new HashMap());
        contentRelationsMap = new HashMap<ContentRelation.Type, Map<ContentRelation, DocumentationPage>>();
        VERSION_COMPARATOR = DocumentationManager::compareVersion;
    }
}

