/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.api;

import com.brandon3055.projectintelligence.api.internal.IPiAPI;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class PiAPI {
    private static IPiAPI INSTANCE = null;

    public static boolean isAPIAvalible() {
        return INSTANCE != null;
    }

    public static void openGui(@Nullable GuiScreen parentScreen) {
        if (PiAPI.isAPIAvalible()) {
            INSTANCE.openGui(parentScreen);
        }
    }

    public static void openGui(@Nullable GuiScreen parentScreen, String pageURI) {
        if (PiAPI.isAPIAvalible()) {
            INSTANCE.openGui(parentScreen, pageURI);
        }
    }

    public static void openGui(@Nullable GuiScreen parentScreen, List<String> pageURIs) {
        if (PiAPI.isAPIAvalible()) {
            INSTANCE.openGui(parentScreen, pageURIs);
        }
    }

    public static void openModPage(@Nullable GuiScreen parentScreen, String modid) {
        if (PiAPI.isAPIAvalible()) {
            INSTANCE.openModPage(parentScreen, modid);
        }
    }

    public static List<String> getPageList() {
        if (PiAPI.isAPIAvalible()) {
            return INSTANCE.getPageList();
        }
        return Collections.emptyList();
    }

    public static List<String> getModPageList(String modid) {
        if (PiAPI.isAPIAvalible()) {
            return INSTANCE.getModPageList(modid);
        }
        return Collections.emptyList();
    }

    public static List<String> getRelatedPages(ItemStack stack) {
        if (PiAPI.isAPIAvalible()) {
            return INSTANCE.getRelatedPages(stack);
        }
        return Collections.emptyList();
    }

    public static List<String> getRelatedPages(String entityName) {
        if (PiAPI.isAPIAvalible()) {
            return INSTANCE.getRelatedPages(entityName);
        }
        return Collections.emptyList();
    }

    public static List<String> getRelatedPages(Fluid fluid) {
        if (PiAPI.isAPIAvalible()) {
            return INSTANCE.getRelatedPages(fluid);
        }
        return Collections.emptyList();
    }

    public static void displayError(String error) {
        PiAPI.displayError(error, false);
    }

    public static void displayError(String error, boolean noRepeat) {
        if (PiAPI.isAPIAvalible()) {
            INSTANCE.displayError(error, noRepeat);
        }
    }

    public static List<String> getSupportedMods() {
        if (PiAPI.isAPIAvalible()) {
            return INSTANCE.getSupportedMods();
        }
        return Collections.emptyList();
    }

    public static KeyBinding getPIGuiKey() {
        if (PiAPI.isAPIAvalible()) {
            return INSTANCE.getPIGuiKey();
        }
        return null;
    }

    public static KeyBinding getETGuiKey() {
        if (PiAPI.isAPIAvalible()) {
            return INSTANCE.getPIGuiKey();
        }
        return null;
    }

    public static KeyBinding getETWorldKey() {
        if (PiAPI.isAPIAvalible()) {
            return INSTANCE.getPIGuiKey();
        }
        return null;
    }
}

