/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.lightoverlay;

import at.feldim2425.moreoverlays.api.lightoverlay.LightScannerBase;
import at.feldim2425.moreoverlays.config.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LightScannerVanilla
extends LightScannerBase {
    private static final AxisAlignedBB TEST_BB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);

    @Override
    public byte getSpawnModeAt(BlockPos pos, World world) {
        if (world.func_175642_b(EnumSkyBlock.BLOCK, pos) >= Config.light_SaveLevel) {
            return 0;
        }
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        if (!state.func_177230_c().canCreatureSpawn(state, (IBlockAccess)world, pos.func_177977_b(), EntityLiving.SpawnPlacementType.ON_GROUND)) {
            return 0;
        }
        if (!LightScannerVanilla.checkCollision(pos, world)) {
            return 0;
        }
        if (world.func_175642_b(EnumSkyBlock.SKY, pos) >= Config.light_SaveLevel) {
            return 1;
        }
        return 2;
    }

    private static boolean checkCollision(BlockPos pos, World world) {
        IBlockState block1 = world.func_180495_p(pos);
        if (block1.func_185915_l() || !Config.light_IgnoreLayer && world.func_180495_p(pos.func_177984_a()).func_185915_l()) {
            return false;
        }
        if (world.func_175623_d(pos) && (Config.light_IgnoreLayer || world.func_175623_d(pos.func_177984_a()))) {
            return true;
        }
        AxisAlignedBB bb = TEST_BB.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (world.func_184144_a(null, bb).isEmpty() && !world.func_72953_d(bb)) {
            if (Config.light_IgnoreLayer) {
                return true;
            }
            AxisAlignedBB bb2 = bb.func_72317_d(0.0, 1.0, 0.0);
            return world.func_184144_a(null, bb2).isEmpty() && !world.func_72953_d(bb2);
        }
        return false;
    }
}

