/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.transport.pipe.IFlowPowerLike;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeEventActionActivate;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventPower;
import buildcraft.api.transport.pipe.PipeEventRedstoneFlux;
import buildcraft.lib.misc.EntityUtil;
import buildcraft.lib.misc.MathUtil;
import buildcraft.transport.pipe.flow.PipeFlowRedstoneFlux;
import buildcraft.transport.statements.ActionPowerLimit;
import java.io.IOException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PipeBehaviourLimiter
extends PipeBehaviour {
    public static final int MAX_SHIFT = 6;
    private int limitShift = 0;

    public PipeBehaviourLimiter(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourLimiter(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.limitShift = MathUtil.clamp(nbt.func_74762_e("limitShift"), 0, 6);
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74768_a("limitShift", this.limitShift);
        return nbt;
    }

    @Override
    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(buffer, side, ctx);
        this.limitShift = buffer.readUnsignedByte();
    }

    @Override
    public void writePayload(PacketBuffer buffer, Side side) {
        super.writePayload(buffer, side);
        buffer.writeByte(this.limitShift);
    }

    @PipeEventHandler
    public void configurePower(PipeEventPower.Configure event) {
        if (this.limitShift == 6) {
            event.disableTransfer();
        } else {
            event.setMaxPower(event.getMaxPower() >> this.limitShift);
        }
    }

    @PipeEventHandler
    public void configurePower(PipeEventRedstoneFlux.Configure event) {
        if (this.limitShift == 6) {
            event.disableTransfer();
        } else {
            event.setMaxPower(event.getMaxPower() >> this.limitShift);
        }
    }

    @PipeEventHandler
    public void onActionActivate(PipeEventActionActivate event) {
        if (event.action instanceof ActionPowerLimit) {
            this.limitShift = ((ActionPowerLimit)event.action).limitShift;
            this.requestReconfigure();
        }
    }

    @Override
    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (EntityUtil.getWrenchHand((EntityLivingBase)player) == null) {
            return false;
        }
        if (!player.field_70170_p.field_72995_K) {
            Object transferInfo;
            int limit;
            EntityUtil.activateWrench(player, trace);
            ++this.limitShift;
            if (this.limitShift > 6) {
                this.limitShift = 0;
            }
            boolean isRf = this.pipe.getFlow() instanceof PipeFlowRedstoneFlux;
            if (this.limitShift == 6) {
                limit = 0;
            } else if (isRf) {
                transferInfo = PipeApi.getRfTransferInfo(this.pipe.getDefinition());
                limit = ((PipeApi.RedstoneFluxTransferInfo)transferInfo).transferPerTick >> this.limitShift;
            } else {
                transferInfo = PipeApi.getPowerTransferInfo(this.pipe.getDefinition());
                limit = (int)((((PipeApi.PowerTransferInfo)transferInfo).transferPerTick >> this.limitShift) / MjAPI.MJ);
            }
            String key = "chat.pipe." + (isRf ? "rf" : "power") + ".iron.mode";
            TextComponentTranslation chat = new TextComponentTranslation(key, new Object[]{limit});
            player.func_146105_b((ITextComponent)chat, true);
            this.requestReconfigure();
        }
        return true;
    }

    private void requestReconfigure() {
        if (this.pipe.getFlow() instanceof IFlowPowerLike) {
            ((IFlowPowerLike)((Object)this.pipe.getFlow())).reconfigure();
            this.pipe.getHolder().scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.BEHAVIOUR);
        }
    }

    @Override
    public int getTextureIndex(EnumFacing face) {
        return 6 - this.limitShift;
    }
}

