/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionQuad;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import java.util.Objects;

public class NodeFuncObjectObjectLongToObject<A, B, R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncObjectObjectLongToObject<A, B, R> function;
    private final StringFunctionQuad stringFunction;
    private final Class<A> argTypeA;
    private final Class<B> argTypeB;
    private final Class<R> returnType;

    public NodeFuncObjectObjectLongToObject(String name, Class<A> argTypeA, Class<B> argTypeB, Class<R> returnType, IFuncObjectObjectLongToObject<A, B, R> function) {
        this(argTypeA, argTypeB, returnType, function, (String a, String b, String c) -> "[ " + NodeTypes.getName(argTypeA) + ", " + NodeTypes.getName(argTypeB) + ", long -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ", " + b + ", " + c + ")");
    }

    public NodeFuncObjectObjectLongToObject(Class<A> argTypeA, Class<B> argTypeB, Class<R> returnType, IFuncObjectObjectLongToObject<A, B, R> function, StringFunctionQuad stringFunction) {
        this.argTypeA = argTypeA;
        this.argTypeB = argTypeB;
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}", "{C}");
    }

    @Override
    public NodeFuncObjectObjectLongToObject<A, B, R> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeLong c = stack.popLong();
        IExpressionNode.INodeObject<B> b = stack.popObject(this.argTypeB);
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a, b, c);
    }

    public FuncObjectObjectLongToObject create(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeObject<B> argB, IExpressionNode.INodeLong argC) {
        return new FuncObjectObjectLongToObject(argA, argB, argC);
    }

    @FunctionalInterface
    public static interface IFuncObjectObjectLongToObject<A, B, R> {
        public R apply(A var1, B var2, long var3);
    }

    public class FuncObjectObjectLongToObject
    implements IExpressionNode.INodeObject<R>,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;
        public final IExpressionNode.INodeObject<B> argB;
        public final IExpressionNode.INodeLong argC;

        public FuncObjectObjectLongToObject(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeObject<B> argB, IExpressionNode.INodeLong argC) {
            this.argA = argA;
            this.argB = argB;
            this.argC = argC;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncObjectObjectLongToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncObjectObjectLongToObject.this.function.apply(this.argA.evaluate(), this.argB.evaluate(), this.argC.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncObjectObjectLongToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new FuncObjectObjectLongToObject(a, b, (IExpressionNode.INodeLong)c), (a, b, c) -> new FuncObjectObjectLongToObject(a, b, (IExpressionNode.INodeLong)c));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new FuncObjectObjectLongToObject(a, b, (IExpressionNode.INodeLong)c), (a, b, c) -> new NodeConstantObject(NodeFuncObjectObjectLongToObject.this.returnType, NodeFuncObjectObjectLongToObject.this.function.apply(a.evaluate(), b.evaluate(), c.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectObjectLongToObject.this.canInline) {
                if (NodeFuncObjectObjectLongToObject.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectObjectLongToObject.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB, this.argC);
        }

        public String toString() {
            return NodeFuncObjectObjectLongToObject.this.stringFunction.apply(this.argA.toString(), this.argB.toString(), this.argC.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectObjectLongToObject.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB, this.argC);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectObjectLongToObject other = (FuncObjectObjectLongToObject)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB) && Objects.equals(this.argC, other.argC);
        }
    }
}

