/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionQuad;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import java.util.Objects;

public class NodeFuncObjectDoubleDoubleToLong<A>
extends NodeFuncBase
implements INodeFunc.INodeFuncLong {
    public final IFuncObjectDoubleDoubleToLong<A> function;
    private final StringFunctionQuad stringFunction;
    private final Class<A> argTypeA;

    public NodeFuncObjectDoubleDoubleToLong(String name, Class<A> argTypeA, IFuncObjectDoubleDoubleToLong<A> function) {
        this(argTypeA, function, (String a, String b, String c) -> "[ " + NodeTypes.getName(argTypeA) + ", double, double -> long ] " + name + "(" + a + ", " + b + ", " + c + ")");
    }

    public NodeFuncObjectDoubleDoubleToLong(Class<A> argTypeA, IFuncObjectDoubleDoubleToLong<A> function, StringFunctionQuad stringFunction) {
        this.argTypeA = argTypeA;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}", "{C}");
    }

    @Override
    public NodeFuncObjectDoubleDoubleToLong<A> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble c = stack.popDouble();
        IExpressionNode.INodeDouble b = stack.popDouble();
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a, b, c);
    }

    public FuncObjectDoubleDoubleToLong create(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeDouble argB, IExpressionNode.INodeDouble argC) {
        return new FuncObjectDoubleDoubleToLong(argA, argB, argC);
    }

    @FunctionalInterface
    public static interface IFuncObjectDoubleDoubleToLong<A> {
        public long apply(A var1, double var2, double var4);
    }

    public class FuncObjectDoubleDoubleToLong
    implements IExpressionNode.INodeLong,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;
        public final IExpressionNode.INodeDouble argB;
        public final IExpressionNode.INodeDouble argC;

        public FuncObjectDoubleDoubleToLong(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeDouble argB, IExpressionNode.INodeDouble argC) {
            this.argA = argA;
            this.argB = argB;
            this.argC = argC;
        }

        @Override
        public long evaluate() {
            return NodeFuncObjectDoubleDoubleToLong.this.function.apply(this.argA.evaluate(), this.argB.evaluate(), this.argC.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            if (!NodeFuncObjectDoubleDoubleToLong.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new FuncObjectDoubleDoubleToLong(a, (IExpressionNode.INodeDouble)b, (IExpressionNode.INodeDouble)c), (a, b, c) -> new FuncObjectDoubleDoubleToLong(a, (IExpressionNode.INodeDouble)b, (IExpressionNode.INodeDouble)c));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new FuncObjectDoubleDoubleToLong(a, (IExpressionNode.INodeDouble)b, (IExpressionNode.INodeDouble)c), (a, b, c) -> NodeConstantLong.of(NodeFuncObjectDoubleDoubleToLong.this.function.apply(a.evaluate(), b.evaluate(), c.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectDoubleDoubleToLong.this.canInline) {
                if (NodeFuncObjectDoubleDoubleToLong.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectDoubleDoubleToLong.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB, this.argC);
        }

        public String toString() {
            return NodeFuncObjectDoubleDoubleToLong.this.stringFunction.apply(this.argA.toString(), this.argB.toString(), this.argC.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectDoubleDoubleToLong.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB, this.argC);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectDoubleDoubleToLong other = (FuncObjectDoubleDoubleToLong)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB) && Objects.equals(this.argC, other.argC);
        }
    }
}

