/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import java.util.Objects;

public class NodeFuncLongLongToDouble
extends NodeFuncBase
implements INodeFunc.INodeFuncDouble {
    public final IFuncLongLongToDouble function;
    private final StringFunctionTri stringFunction;

    public NodeFuncLongLongToDouble(String name, IFuncLongLongToDouble function) {
        this(function, (String a, String b) -> "[ long, long -> double ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncLongLongToDouble(IFuncLongLongToDouble function, StringFunctionTri stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public NodeFuncLongLongToDouble setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeDouble getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeLong b = stack.popLong();
        IExpressionNode.INodeLong a = stack.popLong();
        return this.create(a, b);
    }

    public FuncLongLongToDouble create(IExpressionNode.INodeLong argA, IExpressionNode.INodeLong argB) {
        return new FuncLongLongToDouble(argA, argB);
    }

    @FunctionalInterface
    public static interface IFuncLongLongToDouble {
        public double apply(long var1, long var3);
    }

    public class FuncLongLongToDouble
    implements IExpressionNode.INodeDouble,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeLong argA;
        public final IExpressionNode.INodeLong argB;

        public FuncLongLongToDouble(IExpressionNode.INodeLong argA, IExpressionNode.INodeLong argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public double evaluate() {
            return NodeFuncLongLongToDouble.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeDouble inline() {
            if (!NodeFuncLongLongToDouble.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncLongLongToDouble((IExpressionNode.INodeLong)a, (IExpressionNode.INodeLong)b), (a, b) -> new FuncLongLongToDouble((IExpressionNode.INodeLong)a, (IExpressionNode.INodeLong)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncLongLongToDouble((IExpressionNode.INodeLong)a, (IExpressionNode.INodeLong)b), (a, b) -> NodeConstantDouble.of(NodeFuncLongLongToDouble.this.function.apply(a.evaluate(), b.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncLongLongToDouble.this.canInline) {
                if (NodeFuncLongLongToDouble.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncLongLongToDouble.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB);
        }

        public String toString() {
            return NodeFuncLongLongToDouble.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncLongLongToDouble.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncLongLongToDouble other = (FuncLongLongToDouble)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB);
        }
    }
}

