/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.font;

import buildcraft.api.core.BCLog;
import buildcraft.lib.misc.ColourUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class SpecialColourFontRenderer
extends FontRenderer {
    public static final SpecialColourFontRenderer INSTANCE = new SpecialColourFontRenderer();

    private SpecialColourFontRenderer() {
        super(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
    }

    public int func_175065_a(String text, float x, float y, int color, boolean dropShadow) {
        int next = text.indexOf(ColourUtil.COLOUR_SPECIAL_START);
        int taken = 0;
        if (next > 0) {
            x = SpecialColourFontRenderer.getRealRenderer().func_175065_a(text.substring(0, next), x, y, color, dropShadow);
            taken = next;
        }
        while (next != -1) {
            String sub;
            int end = text.indexOf(TextFormatting.RESET.toString());
            if (end > 0) {
                sub = text.substring(next, end);
                taken = end;
            } else {
                sub = text.substring(next);
                taken = text.length();
            }
            char c = text.charAt(next + 3);
            int thisColour = color;
            try {
                int ord = Integer.parseInt(Character.toString(c), 16);
                thisColour = ColourUtil.getLightHex(EnumDyeColor.func_176764_b((int)ord));
            }
            catch (NumberFormatException nfe) {
                BCLog.logger.warn("[lib.font] Invalid colour string for SpecialColourFontRenderer! " + nfe.getMessage());
            }
            x = SpecialColourFontRenderer.getRealRenderer().func_175065_a(sub, x, y, thisColour, dropShadow);
            next = text.indexOf(ColourUtil.COLOUR_SPECIAL_START, end);
        }
        if (taken < text.length()) {
            x = SpecialColourFontRenderer.getRealRenderer().func_175065_a(text.substring(taken), x, y, color, dropShadow);
        }
        return (int)x;
    }

    private static FontRenderer getRealRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public int func_78256_a(String text) {
        return SpecialColourFontRenderer.getRealRenderer().func_78256_a(text);
    }

    public int func_78263_a(char character) {
        return SpecialColourFontRenderer.getRealRenderer().func_78263_a(character);
    }

    public String func_78269_a(String text, int width) {
        return SpecialColourFontRenderer.getRealRenderer().func_78269_a(text, width);
    }

    public String func_78262_a(String text, int width, boolean reverse) {
        return SpecialColourFontRenderer.getRealRenderer().func_78262_a(text, width, reverse);
    }

    public int func_78267_b(String str, int maxLength) {
        return SpecialColourFontRenderer.getRealRenderer().func_78267_b(str, maxLength);
    }

    public void func_78264_a(boolean unicodeFlagIn) {
        SpecialColourFontRenderer.getRealRenderer().func_78264_a(unicodeFlagIn);
    }

    public boolean func_82883_a() {
        return SpecialColourFontRenderer.getRealRenderer().func_82883_a();
    }

    public void func_78275_b(boolean bidiFlagIn) {
        SpecialColourFontRenderer.getRealRenderer().func_78275_b(bidiFlagIn);
    }

    public List<String> func_78271_c(String str, int wrapWidth) {
        return SpecialColourFontRenderer.getRealRenderer().func_78271_c(str, wrapWidth);
    }

    public boolean func_78260_a() {
        return SpecialColourFontRenderer.getRealRenderer().func_78260_a();
    }

    public int func_175064_b(char character) {
        return SpecialColourFontRenderer.getRealRenderer().func_175064_b(character);
    }
}

