/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.entry;

import buildcraft.lib.client.guide.entry.PageValueType;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.misc.JsonUtil;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class PageValue<T> {
    public final PageValueType<T> type;
    public final String title;
    public final T value;

    public PageValue(PageValueType<T> type, T value) {
        this.type = type;
        this.title = type.getTitle(value);
        this.value = value;
    }

    public static String getTitle(JsonObject json) {
        return JsonUtil.getTextComponent(json, "title", "buildcraft.guide.page.").func_150254_d();
    }

    public boolean matches(Object test) {
        return this.type.matches(this.value, test);
    }

    @Nullable
    public ISimpleDrawable createDrawable() {
        return this.type.createDrawable(this.value);
    }

    public Object getBasicValue() {
        return this.type.getBasicValue(this.value);
    }

    public List<String> getTooltip() {
        return this.type.getTooltip(this.value);
    }

    public PageValue<T> copyToValue() {
        return new PageValue<T>(this.type, this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PageValue other = (PageValue)obj;
        return Objects.equals(this.value, other.value);
    }
}

